/***************************************************************************
                         facemodifier.cpp  -  description
                            -------------------
   begin                : Mon Apr 23 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "facemodifier.h"
#include "uvmodifier.h"
#include "modetoolbar.h"

#include <Entities/face.h>

#include <Entities/mesh.h>
#include <TextureMap/planarwrap.h>
#include <TextureMap/cubewrap.h>
#include <TextureMap/cylinderwrap.h>
#include <TextureMap/sphericalwrap.h>
#include <i3d.h>
#include <i3dworkspace.h>
#include <Views/viewUV.h>
#include "modetoolbar.h"

#define BEGIN(c,x) \
  if( assertSelected(x) && assertSameParent() ) { \
    setStatus( c ); \
    Mesh *m = getSubObjectParent(); \
    vector<int> zzlist = getSubObjectList(); \
    CheckPointCmd *chc = new CheckPointCmd( m );

#define END() \
    chc -> save(); \
    setStatusDone(); \
  } \
  updateViews();

#define SUBOBJECTS() zzlist

int FaceModifier::TYPE = IControl::getUID();

FaceModifier::FaceModifier() : SubObjectModifier( Face::TYPE )
{
   setName( "&Faces" );

   QPopupMenu *map = new QPopupMenu();
   QPopupMenu *pmap = new QPopupMenu();

   pmap -> insertItem( "Top", this, SLOT( slotXZPlaneGizmo() ) );
	 pmap -> insertItem( "Side", this, SLOT( slotYZPlaneGizmo() ) );
	 pmap -> insertItem( "Front", this, SLOT( slotXYPlaneGizmo() ) );
	
   map -> insertItem( "Plane Gizmo", pmap ); //this, SLOT( slotPlaneGizmo() ) );
   map -> insertItem( "Cylinder Gizmo", this, SLOT( slotCylinderGizmo() ) );
   map -> insertItem( "Sphere Gizmo", this, SLOT( slotSphereGizmo() ) );
   map -> insertSeparator();
   map -> insertItem( "Edit UVs", this, SLOT( slotEditUVs() ) );

   m_popup -> insertSeparator();
   m_popup -> insertItem( "Extrude", this, SLOT( slotExtrude() ) );
   m_popup -> insertItem( "Bevel", this, SLOT( slotBevel() ) );
   m_popup -> insertItem( "Reverse", this, SLOT( slotReverse() ) );
   m_popup -> insertItem( "Triangulate", this, SLOT( slotTriangulate() ) );

   m_popup -> insertSeparator();
   m_popup -> insertItem( "Texture Mapping...", map );

   m_popup -> insertSeparator();
   m_popup -> insertItem( "Delete", this, SLOT( slotDelete() ) );

   m_gizmo = 0;
   m_using_gizmo = false;
}

FaceModifier::~FaceModifier()
{}

void FaceModifier::activate()
{
   clearSelection();
   I3D::getWorkspace() -> setCurrentControl( this );
   I3D::setModeMsg( " Face Mode " );
   SelectMode::set( Face::TYPE );
   //change to select mode immediately.
   ModeToolbar::setMode( ModeToolbar::MODE_SELECT );

   updateViews();
}

void FaceModifier::deactivate()
{
}

void FaceModifier::slotExtrude()
{
   Vector4 p;
   BEGIN( "Extruding faces...", 1 );
   getSubObjectParent() -> extrudeFaces( SUBOBJECTS(), p );
   END();

   slotMoveMode();
}

void FaceModifier::slotBevel()
{
   BEGIN( "Beveling faces...", 1 );
   getSubObjectParent() -> bevelFaces( SUBOBJECTS(), 1 );
   END();

   slotScaleUniformMode();

}

void FaceModifier::slotReverse()
{
   BEGIN( "Reversing faces...", 1 );
   getSubObjectParent() -> reverseFaces( SUBOBJECTS() );
   END();

}

void FaceModifier::slotDelete()
{

   BEGIN( "Deleting faces...", 1 );
   getSubObjectParent() -> deleteFaces( SUBOBJECTS() );
   END();
   clearSelection();
}

void FaceModifier::slotTriangulate()
{

   BEGIN( "Deleting faces...", 1 );
   getSubObjectParent() -> triangulateFaces( SUBOBJECTS() );
   END();
   clearSelection();
}

void FaceModifier::slotXYPlaneGizmo()
{
   m_using_gizmo = true;

   if ( m_gizmo != 0 )
   {
			delete m_gizmo;
			m_gizmo = 0;
   }
   m_gizmo = new PlanarWrap();

   m_gizmo -> rotate( 90, 1, 0, 0, 0, 0, 0 );
}
void FaceModifier::slotYZPlaneGizmo()
{
   m_using_gizmo = true;

   if ( m_gizmo != 0 )
   {
			delete m_gizmo;
			m_gizmo = 0;
   }
   m_gizmo = new PlanarWrap();

   m_gizmo -> rotate( 90, 1, 0, 0, 0, 0, 0 );
   m_gizmo -> rotate( -90, 0, 1, 0, 0, 0, 0 );

}
void FaceModifier::slotXZPlaneGizmo()
{
   m_using_gizmo = true;

   if ( m_gizmo != 0 )
   {
			delete m_gizmo;
			m_gizmo = 0;
   }
   m_gizmo = new PlanarWrap();
}


void FaceModifier::slotCylinderGizmo()
{
   m_using_gizmo = true;

   if ( m_gizmo != 0 )
   {
			delete m_gizmo;
			m_gizmo = 0;
   }
   m_gizmo = new CylinderWrap();

}

void FaceModifier::slotSphereGizmo()
{
   m_using_gizmo = true;

   if ( m_gizmo != 0 )
   {
			delete m_gizmo;
			m_gizmo = 0;
   }

   m_gizmo = new SphericalWrap();

}

void FaceModifier::slotCubeGizmo()
{
   m_using_gizmo = true;

   if ( m_gizmo != 0 )
   {
			delete m_gizmo;
			m_gizmo = 0;
   }

   m_gizmo = new CubeWrap();
}

void FaceModifier::slotEditUVs()
{
   if ( assertSelected( 1 ) && assertSameParent() )
   {

      Mesh * m = getSubObjectParent();
      vector<int> zzlist = getSubObjectList();

      ViewUV *v = static_cast<ViewUV *>( I3D::getWorkspace() -> addView( VUV, true ) );

      v -> setMesh( m, zzlist );
      v -> setControl( new UVModifier() );

   }

   updateViews();
}

void FaceModifier::draw()
{
   if ( m_using_gizmo &&
         ( m_gizmo != 0 ) )
   {
      m_gizmo -> draw();
   }
}

void FaceModifier::transform ( Vector4 &diff, Vector4 &center )
{

   if ( ! m_using_gizmo )
   {
      SubObjectModifier::transform( diff, center );
      return ;
   }

   int mode = ModeToolbar::getMode();

   switch ( mode )
   {
      case ModeToolbar::MODE_ROTATE:
         m_gizmo -> rotate( diff, m_selection_center );
         break;
      case ModeToolbar::MODE_MOVE:
         m_gizmo -> move( diff );
         break;
      default:
         static_cast<Entity *>( m_gizmo ) -> scale( diff, m_selection_center );
         break;
   }

}

void FaceModifier::startTransform()
{
   //if we aren'nt using a gizmo, let the parent class handle things
   if ( !m_using_gizmo )
   {
      SubObjectModifier::startTransform();
      return ;
   }

   //otherwise, modify the gizmo...

   m_cmds.clear();

   CheckPointCmd *c = new CheckPointCmd( m_gizmo );

   c -> save();

}


void FaceModifier::endTransform()
{

   //if we aren'nt using a gizmo, let the parent class handle things
   if ( !m_using_gizmo )
   {
      SubObjectModifier::startTransform();
      return ;
   }

   //otherwise, we can just ignore the end cuz it's a
   //checkpnt.

}

void FaceModifier::keyEvent( QKeyEvent *e )
{

   switch ( e->key() )
   {
      case Key_Escape:
         slotQuitGizmo();
         break;
      case Key_Space:
         slotApplyGizmo();
         break;
      default:
         SubObjectModifier::keyEvent( e );
         break;
   }

}

void FaceModifier::slotApplyGizmo()
{
   if ( m_using_gizmo &&
         ( m_gizmo != 0 ) &&
         assertSelected( 1 ) &&
         assertSameParent() )
   {
      setStatus( "Applying UV wrapper..." );
      Mesh *m = getSubObjectParent();
      CheckPointCmd *chc = new CheckPointCmd( m );

      //create a vector of the faces...
      vector<SubObject *> faces;
      faces.reserve( m_selection -> size() );

      SelectionIterator it = m_selection -> begin();

      while ( it != m_selection -> end() )
      {
         faces.push_back( static_cast<SubObject *>( *it ) );
         ++it;
      }

      m_gizmo -> createMapping( & faces );

      chc -> save();
      setStatusDone();
      updateViews();

   }

}

void FaceModifier::slotQuitGizmo()
{

   m_using_gizmo = false;
   delete m_gizmo;
   m_gizmo = 0;
   updateViews();

}
