/***************************************************************************
                          i3dstaticio.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Oct 19 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "i3dstaticio.h"
#include <Entities/entitylib.h>
#include <objectdb.h>
#include <Controls/mateditor.h>
#include <i3d.h>

#include <qregexp.h>
#include <map>
#include <vector>
#include <string>


I3DStaticIO::I3DStaticIO(string name, int mode):FileIO(name, mode), mats(), entity_map(), entity_parentable(), subobject_map(), affected_map()
{
}
I3DStaticIO::~I3DStaticIO(){
}

void I3DStaticIO::write()
{
    out.open(filename.c_str(), ios::out);

    if(!out)
        return;

    out<<"[I3D010]"<<endl;

    vector<Selectable *> *ents = I3D::getDB()->getList();

    //save materials here.
/*
    vector<TextureMaterial *> *materials = I3D::getMatEditor()->getMaterials();

    out<<"[MATERIALS]"<<endl;
    out<<materials->size()<<endl;
    for(int i=0; i<(int)materials->size(); i++){
        (*materials)[i]->write(out);
    }
  */
    Selectable *e;
    for(int j=0; j<(int)ents->size(); j++){
        e = (*ents)[j];
        if(e->isA(Bone::TYPE))
            saveBone((Bone *)e);
        else if(e->isA( Mesh::TYPE ))
            saveMesh((Mesh *)e);
        else if(e->isA( Light::TYPE ))
            saveLight((Light *)e);
        else if(e->isA( Line::TYPE ))
            saveLine((Line *)e, false);
        else if(e->isA( NurbsCurve::TYPE ))
            saveCurve((NurbsCurve *)e);
        else if(e->isA( NurbsSurface::TYPE ))
            saveSurface((NurbsSurface *)e);
        else if(e->isA( Poly::TYPE ))
            saveLine((Spline *) e , true );


    }//for;
    out.close();
}

void I3DStaticIO::saveMesh(Mesh *m)
{

    VertexList *vlist = m->getVerts();
    FaceList *flist = m->getFaces();
    UVList *uvlist = m->getUVs();

    Vertex *v;      //temp vert index;
    Face *t;    //temp triangle;
    string tag;

    out <<"[MESH]"<<endl;

    saveMeta( m );

    out << "[material]"<<endl;
  //  out << I3D::getMatEditor()->getMaterialIndex(m->getTextureMaterial())<<endl;

    out <<"[verts]\n"<<vlist->size()<<endl;
    for(int i=0; i<(int)vlist->size(); i++){
        Vector4 g, n, c;
        v = (Vertex *)(*vlist)[i];
        g=v->getPosition();
        n=v->getNormal();
        c=v->getColor();
        out<<"["<<v->getID()<<"] ";
        out<<g.x<<" "<<g.y<<" "<<g.z<<" ";
        out<<n.x<<" "<<n.y<<" "<<n.z<<" ";
        out<<c.x<<" "<<c.y<<" "<<c.z<<" "<<c.w<<endl;
    }

    out <<"[uvs]\n"<<uvlist->size()<<endl;
    Vector4 uvc;
    for(int i=0; i<(int)uvlist->size(); i++){
        uvc = (*uvlist)[i]->getPosition();
        out<<"["<<(*uvlist)[i]->getID()<<"] ";
        out<<uvc.x<<" "<<uvc.y<<endl;
    }

    //if(tlist->count() > 0){
    out<<"[faces]"<<endl;
    out<<flist->size()<<endl;

    for(int i=0; i<(int)flist->size(); i++){
        t = (Face *)(*flist)[i];
        vector<int> *vs=t->getVerts();
        vector<int> *uvlist = t->getUVs();
        out<<"["<<t->getID()<<"] ";
        out<<vs->size()<<" ";
        for(int j=0; j<(int)vs->size(); j++){
            out<<(*vs)[j]<<" ";   //outs the index into vert list
        }
        for(int j=0; j<(int)uvlist->size(); j++){
            out<<(*uvlist)[j]<<" "; //outs the index into the uv list
        }
        out<<endl;
    }

}

void I3DStaticIO::saveLine(Spline *o, bool poly)
{
    VertexList *vlist = o->getVerts();

    Vertex *v;      //temp vert index;
    string tag;

    if(poly)
        out <<"[POLY]"<<endl;
    else
        out <<"[LINE]"<<endl;

    saveMeta( o );

    out <<"[verts]\n"<<vlist->size()<<endl;
    for(int i=0; i<(int)vlist->size(); i++){
        v = (Vertex *)(*vlist)[i];
        Vector4 &g=v->getPosition();
        Vector4 &n=v->getNormal();
        Vector4 &c=v->getColor();

        out<<"["<<v->getID()<<"] ";
        out<<g.x<<" "<<g.y<<" "<<g.z<<" ";
        out<<n.x<<" "<<n.y<<" "<<n.z<<" ";
        out<<c.x<<" "<<c.y<<" "<<c.z<<" "<<c.z<<endl;
        out<<endl;
    }

}
void I3DStaticIO::saveLight(Light *l)
{

}

void I3DStaticIO::saveSurface(NurbsSurface *s)
{
    Vector4 p;
    Quat q;
    p = s->getPosition();
    q = s->getOrientation();

    out <<"[SURFACE]"<<endl;

    saveMeta( s );

    out << "[material]"<<endl;
//    out << I3D::getMatEditor()->getMaterialIndex(s->getTextureMaterial())<<endl;

    out << "[steps]"<<endl;
    out << s->getUSegs()<<" "<<s->getVSegs()<<endl;

    vector<float> uknots = s->getUKnots();
    vector<float> vknots = s->getVKnots();
    int udegree = s->getUDegree();
    int vdegree = s->getVDegree();

    VertexList *verts = s->getVerts();

    out << "[degreeU]"<<endl;
    out << udegree << endl;
    out << "[degreeV]"<<endl;
    out << vdegree << endl;
    out << "[knotsU]"<<endl;
    out << uknots.size()<<endl;
    for(int i=0; i<(int)uknots.size(); i++){
        out << uknots[i] << " ";
    }
    out << endl;
    out << "[knotsV]"<<endl;
    out << vknots.size()<<endl;
    for(int i=0; i<(int)vknots.size(); i++){
        out << vknots[i] << " ";
    }
    out << endl;


    out << "[ctrlpts]"<<endl;
    out << s->getNumUPoints()<<" "<<s->getNumVPoints()<<endl;
    //	out << verts->size()<<endl;
    for(int i=0; i<(int)verts->size(); i++){
        Vector4 vp;
        vp = (*verts)[i]->getPosition();
        out << "["<<(*verts)[i]->getID()<<"] ";
        out << vp.x << " "<<vp.y<<" "<<vp.z<<endl;
    }


}
void I3DStaticIO::saveCurve(NurbsCurve *c)
{
    Vector4 p;
    Quat q;
    p = c->getPosition();
    q = c->getOrientation();

    out <<"[CURVE]"<<endl;

    saveMeta( c );

    vector<float> knots = c->getUKnots();
    int degree = c->getUDegree();
    VertexList *verts = c->getVerts();

    out << "[steps]"<<endl;
    out << c->getUSegs()<<endl;

    out << "[degree]"<<endl;
    out << degree << endl;
    out << "[knots]"<<endl;
    out << knots.size()<<endl;
    for(int i=0; i<(int)knots.size(); i++){
        out << knots[i] << " ";
    }
    out << endl;

    out << "[ctrlpts]"<<endl;
    out << verts->size()<<endl;
    for(int i=0; i<(int)verts->size(); i++){
        Vector4 vp;
        vp = (*verts)[i]->getPosition();
        out << "["<<(*verts)[i]->getID()<<"] ";
        out << vp.x << " "<<vp.y<<" "<<vp.z<<endl;
    }


}
void I3DStaticIO::saveBone(Bone *b)
{
    Vector4 p;
    Quat q;
    p = b->getPosition();
    q = b->getOrientation();

    out <<"[BONE]"<<endl;

    saveMeta( b );

    out<<"[length]"<<endl;
    out<<b->getLength()<<endl;
    out<<"[stiffness]"<<endl;
    out<<b->getStiffness()<<endl;
    out<<"[envelope]"<<endl;
    p= b->getEnvelope();
    out<<p.x<<" "<<p.y<<" "<<p.z<<endl;
    out<<"[limits]"<<endl;
    Vector4 vlimit;
    vlimit = b->getXRot();
    out<<vlimit.x << " " <<vlimit.y<<endl;
    vlimit = b->getYRot();
    out<<vlimit.x << " " <<vlimit.y<<endl;
    vlimit = b->getZRot();
    out<<vlimit.x << " " <<vlimit.y<<endl;

    out<<"[affected]"<<endl;

    vector<Vertex *> *alist = b->getAffected();
    out<<alist->size()<<endl;
    for(int i=0; i<(int)alist->size(); i++){
        out << "["<<(*alist)[i]->getID()<<"]"<<endl;
    }

}


void I3DStaticIO::read()
{
    int num_mats;

    in.open(filename.c_str(), ios::in);

    if(!in)
        return;


    char tag[128];
    //read in the version tag
    in>>tag>>ws;
    if(strcmp(tag, "[I3D009]")==0) {
        version = VERSION_009;
        cerr << "Version 9" << endl;
    }else if(strcmp(tag, "[I3D008]")==0) {
        version = VERSION_008;
        cerr << "Version 8" << endl;
    }else if(strcmp(tag, "[I3D007]")==0) {
        version = VERSION_007;
        cerr << "Version 7" << endl;
    }else if(strcmp(tag, "[I3D010]")==0) {
        version = VERSION_010;
        cerr << "Version 10" << endl;
    } else {
        version = VERSION_006;
        cerr << "Version 6" << endl;
		}

    //read in materials
    mats.clear();
    in>>tag>>ws;
    in>>num_mats>>ws;
    mats.reserve(num_mats);
    for(int i=0; i<num_mats; i++){
        TextureMaterial *t = new TextureMaterial();
        t->read(in);

//        I3D::getMatEditor()->addMaterial(t);
        mats.push_back(t);
    }

    in>>tag>>ws;
    while(tag != 0 && strcmp(tag, "")!=0){//in->atEnd()){
        if(strcmp(tag,"[MESH]")==0)
            readMesh();
        if(strcmp(tag,"[LINE]")==0)
            readLine( false );
        if(strcmp(tag,"[LIGHT]")==0)
            readLight();
        if(strcmp(tag, "[SURFACE]")==0)
            readSurface();
        if(strcmp(tag, "[CURVE]")==0)
            readCurve();
        if(strcmp(tag, "[BONE]")==0)
            readBone();
        if(strcmp(tag, "[POLY]")==0)
            readLine( true );


        in>>tag>>ws;
    }
    in.close();

    //take care of parenting here...
    MultiEntityMap::iterator it;

    /*
    it = entity_map.begin();
    while( it != entity_map.end() ) {
    	cerr << "Entities:"<<it->first<<"("<<it->second<<")"<<endl;
    	++it;
}
    */

    it = entity_parentable.begin();
    while (it != entity_parentable.end()){
        Entity * e = it->second;
        //		cerr << "Assigning "<<it->first<<" as parent.("<< entity_map[it->first]<<")"<<endl;
        e->setParent( entity_map[it->first] );
        ++it;
    }

    //take care of affecting here...
    AffectedMap::iterator at = affected_map.begin();
    while (at != affected_map.end()){
        Bone * b = (Bone *)at->second;
        string v_id = at->first;

        Vertex *v = (Vertex *) subobject_map[v_id];

        b->addAffected( v );
        ++at;
    }

    //save the offsets
    at = affected_map.begin();
    while (at != affected_map.end()){
        Bone * b = (Bone *)at->second;

        b -> saveAffectedOffsets( false );

        ++at;
    }


}

void I3DStaticIO::readMesh()
{
    string tag;
    char buffer[128];
    float x, y, z;
    int ix;
    int uvx;
    float r, g, b, a;

    float nx, ny, nz;
    int num;
    int count;
    char id[32];

    Mesh *m = new Mesh();

    vector<Vertex *> vlist;
    vector<Vector4> uvlist;

    //vector<Face *> flist;

    readMeta( m );

    in>>buffer>>ws; //read in the material name tag
    in>>ix>>ws;     //read in the material index;

    if(ix != -1)
        m->setTextureMaterial(mats[ix]);

    in>>buffer>>ws; //read in the verts tag
    in>>num>>ws; //read in the number of verts;

    vlist.reserve(num);

    Vertex *vt;     //temp vertex;
    for(int i=0; i<num; i++){
        in >> id >> x  >> y  >> z  >> ws;
        in       >> nx >> ny >> nz >> ws;
        in			 >> r  >> g  >> b  >> a >> ws;
        vt = m -> createVertex( x, y, z );
        vt -> setNormal(nx, ny, nz);
        if ( r >= 0 && g >= 0 && b >= 0 && a >= 0 )
            vt -> setColor( r, g, b, a );
        vlist.push_back(vt);

        subobject_map.insert(SubObjectPair(id, vt));
    }

    in>>buffer>>ws; //read in the uvs tag
    in>>num>>ws; //read in the number of uvs;
    uvlist.reserve(num);

    /**TEXTURE COORDINATES ARE NOT INCLUDED IN THE MAPPING
      *AND ARE NOT PART OF THE HIERARCHY OR ANIMATABLE RIGHT NOW>
      */
    Vector4 v;
    for(int i=0; i<num; i++){
        in >> id >> x >> y >>ws;
        v.assign(x, y, 0, 0);
        uvlist.push_back(v);
    }

    in>>buffer>>ws;  //read in the Faces tag
    in>>num>>ws;  //read in the number of Faces


    cerr<<buffer<<" "<<num<<endl;


    for(int i=0; i<num; i++){
        Face * f;
        in >> id >> count;

        vector<int> fverts;
        vector<int> fuvs;

        fverts.reserve(count);
        fuvs.reserve(count);

        //read the verts
        for(int h=0; h<count; h++){
            in >> ix;
            fverts.push_back(ix);
        }

        //read the uvs
        for(int h=0; h<count; h++){
            in >> uvx;
            fuvs.push_back(uvx);
        }


        f = m -> createFace( fverts );
        for(int h=0; h<count; h++){
            f -> setUVCoord( h, uvlist[ fuvs[h] ] );
        }


        subobject_map.insert(SubObjectPair(id, f));

    }

    I3D::getDB()->add(m);

}

void I3DStaticIO::readLine(bool poly)
{

    float x, y, z;
    float nx, ny, nz;
    float r, g, b, a;

    char tag[256];
    char id[23];

    int nv;
    Spline *s;

    if(poly)
        s = new Poly();
    else
        s = new Line();

    readMeta( s );

    in >> tag >> ws; //read in the vert tag.
    in >> nv >> ws;

    for(int i=0; i<nv; i++)	{

        in >> id >> ws;

        in >> x  >> y  >> z  >> ws;
        in >> nx >> ny >> nz >> ws;
        in >> r  >> g  >> b  >> a  >> ws;

        Vertex *v = s -> createVertex( x, y, z );
        v -> setNormal( nx, ny, nz );
        if ( r >= 0 && g >= 0 && b >= 0 && a >= 0 )
            v -> setColor( r, g, b, a );

        subobject_map.insert(SubObjectPair(id, v));

    }

    if ( poly ) {
        ((Poly*)s) -> triangulate();
        ((Poly*)s) -> setDrawable( true );
    }

    I3D::getDB()->add( s );
}

void I3DStaticIO::readLight()
{
}

void I3DStaticIO::readCurve()
{

    NurbsCurve *c = new NurbsCurve();

    string tmp;
    float x, y, z;
    char id[32];
    char tag[256];
    int usegs;

    readMeta( c );

    in >> tag>>ws; //read in the subdivision tag
    in >> usegs >>ws;

    c->setUSegs(usegs);

    int degree;
    int num_knots;
    int num_pts;
    vector<float> knots;
    vector<Vector4> pts;
    float f;

    in >> tag>>ws; //read in the degree tag
    in >>degree>>ws;
    in >> tag>>ws; //read in the knots tag
    in >> num_knots>>ws;

    for(int i=0; i<num_knots; i++){

        in >> f >> ws;
        knots.push_back(f);

    }


    /**WARNING:: CURVE POINTS ARE NOT READ IN AS VERTICES, THEY
      *ARE READ IN AS POSITIONS.  THAT MEANS THEY CAN"T BE PUT INTO
      *A ID_MAP FOR ANIMATION, OR HIERARCHY PURPOSES. THIS SHOULD BE
      *FIXED!
      */

    in >> tag >> ws; //read in teh ctrlpts tag
    in >> num_pts >> ws;

    for(int i=0; i<num_pts; i++){

        if(version > VERSION_006)
            in >> id >> x >> y >> z >> ws;
        else
            in >> x >> y >> z >> ws;
        pts.push_back(Vector4(x, y, z, 1));

    }

    c->createCurve(pts, knots, degree);

   I3D::getDB()->add(c);

}

void I3DStaticIO::readSurface()
{
    NurbsSurface *s = new NurbsSurface();

    string tmp;
    float x, y, z;
		int n;
		
    char tag[256];
    char id[32];

    cerr<< "Reading surface"<<endl;

    readMeta( s );

    in>>tag>>ws; //read in the material name tag
    in>>n>>ws;     //read in the material index;

    cerr << "Material:"<<tag<<" "<<n << endl;
    if(n != -1)
        s->setTextureMaterial( mats[n]);

    int udegree;
    int vdegree;
    int num_uknots;
    int num_vknots;
    int num_upts;
    int num_vpts;
    int usegs, vsegs;
    vector<float> uknots;
    vector<float> vknots;
    vector<Vector4> pts;
    float f;

    in >> tag>>ws; //read in the subdivision tag
    in >> usegs >> vsegs>>ws;

    cerr<<usegs<<" "<<vsegs<<endl;

    s->setUSegs(usegs);
    s->setVSegs(vsegs);

    in >> tag>>ws; //read in the udegree tag
    in >> udegree>>ws;

    in >> tag>>ws; //read in the vdegree tag
    in >> vdegree>>ws;


    in >> tag>>ws; //read in the uknots tag
    in >> num_uknots>>ws;
    for(int i=0; i<num_uknots; i++){
        in >> f >> ws;
        uknots.push_back(f);
    }

    in >> tag>>ws; //read in the vknots tag
    in >> num_vknots>>ws;
    for(int i=0; i<num_vknots; i++){
        in >> f >> ws;
        vknots.push_back(f);
    }


    in >> tag >> ws; //read in the ctrlpts tag
    in >> num_upts >> num_vpts >> ws;

    cerr<< tag<< " " << num_upts <<	" "<<num_vpts << endl;
    Vector4 a;
    for(int i=0; i<num_upts * num_vpts; i++){
        in >> id >> x >> y >> z >> ws;
        a.assign(x, y, z, 1);
        pts.push_back( a );
    }

    cerr << "setup surface"<<endl;
    s->createSurface(pts, num_upts, num_vpts, uknots, vknots, udegree, vdegree);

    I3D::getDB()->add(s);

}

void I3DStaticIO::readBone()
{
    Bone *b = new Bone(0, 1);

    string tmp;
    float x, y;
    char id[32];
    char tag[256];
    int n;
    Vector4 p;

    readMeta( b );

    //read in the bone options...
    in >> tag>> ws;     //read in the length tag
    in >> x >> ws;
    b->setLength(x);
    in >> tag >> ws;    //read in the stiffness tag.
    in >> x >> ws;
    b->setStiffness(x);
    in >> tag >> ws;  //read in the envelope tag.
    in >> p.x >> p.y >> p.z >> ws;

    b->setEnvelope( p );
    in >> tag >> ws;    //read in the limits tag.
    in >> x >> y >> ws;
    b->setXRot(y, x);
    in >> x >> y >> ws;
    b->setYRot(y, x);
    in >> x >> y >> ws;
    b->setZRot(y, x);

    in >> tag >> ws;    //read in the affected tag.
    in >> n >> ws;      //read in number of affected;
    for(int i=0; i<n; i++){
        in >> id >> ws;
        affected_map.insert(AffectedPair(id, b));
    }

    I3D::getDB()->add(b);


}

/** Writes the common entity meta data that is attached to
  * each entity, such as parent, position, orientation, name,
  * and notes.
  */

void I3DStaticIO::saveMeta(Entity *e)
{

    Vector4 &p = e->getPosition();
    Quat	&q = e->getOrientation();
    out <<"[id]"<<endl;
    out << e->getID() <<endl;
    out <<"[parent]"<<endl;
    if(e->getParent()==0)
        out << "-1"<<endl;
    else
        out << e->getParent()->getID()<<endl;


    out <<"[pos]\n"<<p.x<<" "<<p.y<<" "<<p.z<<endl;
    out <<"[quat]\n"<<q.v.x<<" "<<q.v.y<<" "<<q.v.z<<" "<<q.w<<endl;


    out << "[visible]" << endl;
    out << e -> isVisible() << endl;
    out << "[visibility_group]" << endl;
    out << e -> getVisibilityGroup() << endl;

    out <<"[name]"<<endl;
    string s = e->getName();
    out << s.size() << endl;
    out << s.c_str()<<endl; //write the name.
    out <<"[notes]"<<endl;
    s = e->getNotes();
    out << s.size() << endl;
    out << s.c_str() <<endl; //write the notes.

    out << "[misc]"<<endl;

    // save all the arbitrary data attached to the entity;
    IDataMap *data = e -> getAllData();

    out << data -> size() << endl;

    IDataMap::iterator it = data -> begin();
    while( it != data -> end() ) {
        IData *d = it->second;
        string tag = d -> getTag();
        string sd = d -> toString();
        if(sd[ sd.size()-1 ] != '\n' ) {
            sd = sd + "\n";
        }
        out << "[" << tag.c_str() << "]" << endl;
        out << sd.length()-1 <<endl;
        out << sd.c_str(); //newline is in the string
        ++it;
    }



}

void I3DStaticIO::readMeta(Entity *e)
{

    string tmp;
    float x, y, z, w;
    char id[32];
    char tag[256];
    char parent_id[32];
    int n;

    //read in the entity id
    in>>tag>>ws;
    in>>id>>ws;
    entity_map.insert(EntityPair(id, e));

    //read in the parent tag.
    in>>tag>>ws;  //read in the parent tag
    in>>parent_id>>ws; //read in the parent tag;


    //insert the mesh into the map.
    if(strcmp(parent_id, "[-1]") != 0) {
        cerr << "Inserting parent id:"<<parent_id<<endl;
        entity_parentable.insert(MultiEntityPair(parent_id, e ));
    }

    in >>tag>>ws; //read in the pos tag
    in >>x>>y>>z>>ws; //read in pos
    e->setPosition(x, y, z);
    in >>tag>>ws; //read in the quat tag
    in >>x>>y>>z>>w>>ws;
    Quat q(x, y, z, w);
    e->setOrientation(q);

    if( version == VERSION_010 ) {
		
	    in >> tag >> ws; //read in visibility flag.
	    in >> n >> ws;  //read in the flag
	    e -> setVisible( n );
	
	    in >> tag >> ws; //read in the vis group flag.
	    in >> n >> ws;
	    if( n > 0 )
		    e -> setVisibilityGroup( n );
	  }
			
    in>>tag>>ws; //read in the name tag
    in>> n >> ws;
    char *name = new char[n+1];
    in.read(name, n);
    name[n] = '\0';
    e->setName( name );
    in >> ws;
    delete name;

    in>>tag>>ws; //read in the notes tag
    in>> n >> ws;
    char *notes = new char[n+1];
    in.read(notes, n);
    notes[n] = '\0';
    e->setNotes( notes );
    in >> ws;
    delete notes;

    in >> tag >> ws; //read in the misc tag.
    in >> n >> ws; //read in the number of misc attachments to the entity.

    string stag;
    int tag_size;
    for(int i=0; i<n; i++ ) {
        //in >> tag >> ws; //read in the particular tag.
        in >> stag >> ws;
        stag = stag.substr(1, (int)stag.length()-2);
        in >> tag_size >> ws; //read the length of the data.
        char *tbuf = new char[tag_size+1];
        in.read(tbuf, tag_size);
        tbuf[tag_size] = '\0';
        in >> ws;
        IData *d = IData::create( stag );
        d -> init( tbuf );

        e -> putData( stag, d );
        delete tbuf;
    }

}



