/***************************************************************************
                         nurbscurveparser.cpp  -  description
                            -------------------
   begin                : Mon Jun 10 2002
   copyright            : (C) 2002 by janders
   email                : janders@damascus.onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "nurbscurveparser.h"

#include "nurbscurve.h"

NurbsCurveParser::NurbsCurveParser()
{}

NurbsCurveParser::~NurbsCurveParser()
{}


void NurbsCurveParser::write( QDomElement & parent, Typed * t )
{
  printf( "Writing curve\n" );
  cerr << "Writing curve\n" <<endl;

  NurbsCurve * s = ( NurbsCurve * ) t ;
  QDomDocument doc = parent.ownerDocument();

  QDomElement surface;
  QDomElement e;

  surface = doc.createElement( "curve" );
  parent.appendChild( surface );

  writeMeta( surface, s );

  e = doc.createElement( "control_pts" );
  surface.appendChild( e );

  writeVertices( e, s, "cp" );

  e = doc.createElement( "degree_u" );
  e.setAttribute( "val", s -> getUDegree() );
  surface.appendChild( e );


  e = doc.createElement( "knots_u" );
  writeKnots( e, s-> getUKnots() );
  surface.appendChild( e );

}

Typed * NurbsCurveParser::read( QDomElement & element )
{
  vector < float > u_knots;

  int degree_u;

  NurbsCurve *c = new NurbsCurve();
  QDomElement e;

  readMeta( element, c );


  e = element.namedItem( "control_pts" ).toElement();
  readVertices( e, c, "cp" );

  e = element.namedItem( "degree_u" ).toElement();
  degree_u = atoi( e.attributeNode( "val" ).value() );
  e = element.namedItem( "knots_u" ).toElement();
  u_knots = readKnots( e );

  //create a curve here...
  c->createCurve(u_knots, degree_u);

  return c;

}

void NurbsCurveParser::writeKnots( QDomElement & element, FloatVector v )
{
  QDomDocument doc = element.ownerDocument();
  QDomElement e;

  for ( int i = 0; i < ( int ) v.size(); i++ )
  {
    e = doc.createElement( "knot" );
    e.setAttribute( "val", v[ i ] );
    element.appendChild( e );
  }
}

FloatVector NurbsCurveParser::readKnots( QDomElement & element )
{
  FloatVector v;
  QDomNodeList nl;
  QDomElement e;

  nl = element.elementsByTagName( "knot" );

  for ( int i = 0; i < ( int ) nl.length(); i++ )
  {
    e = nl.item( i ).toElement();
    v.push_back( atof( e.attributeNode( "val" ).value() ) );
  }

  return v;
}

