/***************************************************************************
                         lineparser.cpp  -  description
                            -------------------
   begin                : Mon Jun 10 2002
   copyright            : (C) 2002 by janders
   email                : janders@damascus.onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lineparser.h"
#include "line.h"
#include "poly.h"

LineParser::LineParser()
{}

LineParser::~LineParser()
{}


void LineParser::write( QDomElement & element, Typed * t )
{
  Object * m = ( Object * ) t ;
  QDomDocument doc = element.ownerDocument();

  QDomElement obj;
  QDomElement e;

  if ( m->getType() == Line::TYPE )
    obj = doc.createElement( "line" );
  else
    obj = doc.createElement( "poly" );

  element.appendChild( obj );

  writeMeta( obj, m );

  e = doc.createElement( "vertices" );

  obj.appendChild( e );

  writeVertices( e, m );
}

Typed * LineParser::read( QDomElement & element )
{
  QDomElement e;
  Object *m;

  if ( strcmp( "poly", element.tagName().ascii() ) == 0 )
    m = new Poly();
  else
    m = new Line();

  readMeta( element, m );

  e = element.namedItem( "vertices" ).toElement();

  readVertices( e, m );

  return m;
}
