/***************************************************************************
                        idata.h  -  description
                           -------------------
  begin                : Tue Apr 24 2001
  copyright            : (C) 2001 by Jon Anderson
  email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IDATA_H
#define IDATA_H

#include <string>
#include <map>

using namespace std;

class IData;
typedef map<string, IData *, less<string> > IDataMap;
typedef IDataMap::value_type IDataEntry;

/**
  * This is the base class for all arbitrary data attached to
  * an Entity.
  *
  *@author Jon Anderson
  */

class IData
{

public:
   IData( string );
   virtual ~IData();

   /** Gets a textual representation of the data, esp for storing in a file.
     * this should be overridden in all subclasses.
     */
   virtual string toString()
   {
      return m_data;
   };

   /** Initializes this IData from a string, esp from a file.
     * this should be overridden in all subclasses.
     */
   virtual void init( string s )
   {
      m_data = s;
   };

   /** Clones an IData.
     * this should be overridden in all subclasses.
     */
   virtual IData* clone();

   /** Creates a specific type of IData. */
   static IData * create( string tag );


   static int registerData( IData * );




   string & getTag()
   {
      return m_tag;
   };

private:
   static IDataMap m_registry;

   /* A store for the textual representation of the string
    * so it can be stored again in case the creator isn't available in
    * the factory
    */
   string m_data;
   string m_tag;

};

#endif
