/***************************************************************************
                        group.h  -  description                              
                           -------------------                                         
  begin                : Sat Nov 6 1999                                           
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef GROUP_H
#define GROUP_H

#include "entity.h"
#include <qlist.h>

/**A group is a collection of entities.  Grouping allows
a artist to group entities in ways which facilate modelling.
A group mainly consists of an entity list.  Every 
action done to the group is merely passed 
down to each of it's sub entities.
 
Groups can also be grouped together to create a hierarchial
representation of entitiees.
  *@author Jon Anderson
  */

class Group : public Entity
{

public:
   Group();
   ~Group();

   void addEntity( Entity * );
   void removeEntity( Entity * );
   void move( float x, float y, float z );
   void rotate( float amount, float x, float y, float z, float px, float py, float pz );
   void scale( float x, float y, float z, float px, float py, float pz );


private:
   QList<Entity> entity;


};

#endif
