/***************************************************************************
                       ctrlpt.cpp  -  description                
                          -------------------                   
 begin                : Sun Apr 25 1999                    
 copyright            : (C) 1999 by Jonathan E. Anderson            
 email                : ande1514@tc.umn.edu               
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "ctrlpt.h"
#include "vertex.h"
#include "nurbssurface.h"
#include "nurbscurve.h"



CtrlPt::CtrlPt( float x, float y, float z, Object *_parent )
    : Vertex( x, y, z, _parent ) , tangent()
{
  i = 0;
  j = 0;
}

CtrlPt::CtrlPt( Object *_parent )
    : Vertex( _parent ), tangent()
{
  i = 0;
  j = 0;
}


CtrlPt::~CtrlPt()
{
  // delete tangent;

}

int CtrlPt::draw( int mode )
{
  return Vertex::draw( mode );
}


void CtrlPt::saveKeyframe( Keyframe *k )
{
  Vertex::saveKeyframe( k );
}

void CtrlPt::loadKeyframe( Keyframe *k )
{
  Vertex::loadKeyframe( k );
}

/**Scales about a point */
void CtrlPt::scale( float x, float y, float z, float ox, float oy, float oz )
{
  Vector4 before = pos;
  before.x = ox + ( ( before.x - ox ) * x );
  before.y = oy + ( ( before.y - oy ) * y );
  before.z = oz + ( ( before.z - oz ) * z );

  Vector4 dif = before - pos;

  move( dif.x, dif.y, dif.z );



}

/**Overloaded function for moving NURBS ctrlpts.*/
void CtrlPt::move( float x, float y, float z )
{
  Vector4 before = pos;
  Vertex::move( x, y, z );

  Vector4 dif ;

  dif = pos - before;

  if ( m_parent -> isA( NurbsSurface::TYPE ) )
    ( ( NurbsSurface* ) m_parent ) ->moveControlPoint( this, dif.x, dif.y, dif.z );

  if ( m_parent -> isA( NurbsCurve::TYPE ) )
    ( ( NurbsCurve* ) m_parent ) ->moveControlPoint( this, dif.x, dif.y, dif.z );

}

void CtrlPt::rotate( float amount, float x, float y, float z, float px, float py, float pz )
{
  //change amount to radians
  amount = M_PI / 180 * amount;
  Quat q( Vector3( x, y, z ), amount );
  Matrix44 m;
  q.InsertInMatrix( m.m );

  Vector4 newpos( m * pos );
  setPosition( newpos.x, newpos.y, newpos.z );

}


























