/***************************************************************************
                         rotatecommand.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "rotatecommand.h"

RotateCommand::RotateCommand(Transformable *_e, Vector4 &s, Vector4 &p):PropertyCommand(_e)
{
	newAmount = s;
	oldAmount = s;
	oldAmount.w = -oldAmount.w;
	pt = p;
}
RotateCommand::~RotateCommand(){
}
/** Rotate the Entity to the new location. */
bool RotateCommand::execute()
{
	if( e ==0) {
		cerr << "Action nolonger doable..."<<endl;
		return false;
	}		

	e->rotate(newAmount, pt);
	return true;
}
/** Rotate the entity to the old orientation. */
bool RotateCommand::undo()
{
	if( e == 0) {
		cerr << "Action nolonger undoable..."<<endl;
		return false;
	}		

	e->rotate(oldAmount, pt);
	return true;
}
