/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "manager.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "marshal.h"
#include "service-manager.h"

G_DEFINE_TYPE(Manager, manager, G_TYPE_OBJECT)

#define GET_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE((o), TYPE_MANAGER, ManagerPrivate))

typedef struct _ManagerPrivate ManagerPrivate;

struct _ManagerPrivate {
  ServiceManager *sm;
  ConnmanManager *connman;
};

enum {
  TECHNOLOGY_STATE_CHANGED,
  TECHNOLOGY_AVAILABILITY_CHANGED,
  LAST_SIGNAL,
};

static guint signals[LAST_SIGNAL] = { 0 };

struct service_state_string
{
  const gchar *str;
  ConnmanServiceState state;
};

static void manager_dispose(GObject *object)
{
  Manager *self = MANAGER(object);
  ManagerPrivate *priv = GET_PRIVATE(self);

  if (priv->connman != NULL) {
    g_object_unref(priv->connman);
    priv->connman = NULL;
  }

  G_OBJECT_CLASS(manager_parent_class)->dispose(object);
}

static void manager_finalize(GObject *object)
{
  G_OBJECT_CLASS(manager_parent_class)->finalize(object);
}

static void manager_class_init(ManagerClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS(klass);
  guint signal;

  g_type_class_add_private(klass, sizeof(ManagerPrivate));

  object_class->dispose = manager_dispose;
  object_class->finalize = manager_finalize;

  signal = g_signal_new("technology-state-changed", G_TYPE_FROM_CLASS(klass),
			G_SIGNAL_RUN_LAST, 0, NULL, NULL,
			_marshal_VOID__STRING_BOOLEAN,
			G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
  signals[TECHNOLOGY_STATE_CHANGED] = signal;

  signal = g_signal_new("technology-availability-updated",
			G_TYPE_FROM_CLASS(klass), G_SIGNAL_RUN_LAST,
			0, NULL, NULL, _marshal_VOID__STRING_BOOLEAN,
			G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
  signals[TECHNOLOGY_AVAILABILITY_CHANGED] = signal;
}

static void manager_init(Manager *self)
{
}

const gchar *manager_icon_name(ConnmanServiceType type, gint signal)
{
  return ICON_CONNECTED_DEFAULT;
}

void manager_notify(Manager *self, const gchar *summary, const gchar *body,
		    const gchar *icon)
{
}

void manager_request_scan(Manager *self)
{
}

void manager_set_debug_level(Manager *self, gint level)
{
}

UIProxy *manager_get_ui(Manager *self)
{
  return NULL;
}

ConnmanManager *manager_get_connman(Manager *self)
{
  ManagerPrivate *priv = GET_PRIVATE(self);

  return priv->connman;
}

ServiceManager *manager_get_service_manager(Manager *self)
{
  ManagerPrivate *priv = GET_PRIVATE(self);

  return priv->sm;
}


Manager *manager_new(void)
{
  Manager *self;
  ManagerPrivate *priv;

  self = g_object_new(TYPE_MANAGER, NULL);
  priv = GET_PRIVATE(self);

  priv->sm = service_manager_new(self);
  priv->connman = connman_manager_new();

  return self;
}
