/*
 * indicator-network - user interface for connman
 *
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <libdbusmenu-glib/menuitem.h>

#include "marshal.h"

/* Signals */
enum {
	ITEM_ACTIVATED,
	LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = { 0 };

G_DEFINE_TYPE(DbusmenuMenuitem, dbusmenu_menuitem, G_TYPE_OBJECT);

static void dbusmenu_menuitem_dispose(GObject *object)
{
  G_OBJECT_CLASS(dbusmenu_menuitem_parent_class)->dispose(object);
}

static void dbusmenu_menuitem_finalize(GObject *object)
{
  G_OBJECT_CLASS(dbusmenu_menuitem_parent_class)->finalize(object);
}

static void dbusmenu_menuitem_class_init(DbusmenuMenuitemClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  object_class->dispose = dbusmenu_menuitem_dispose;
  object_class->finalize = dbusmenu_menuitem_finalize;

  signals[ITEM_ACTIVATED] = g_signal_new(DBUSMENU_MENUITEM_SIGNAL_ITEM_ACTIVATED,
					 G_TYPE_FROM_CLASS(klass),
					 G_SIGNAL_RUN_LAST,
					 G_STRUCT_OFFSET(DbusmenuMenuitemClass, item_activated),
					 NULL, NULL,
					 _marshal_VOID__UINT,
					 G_TYPE_NONE, 1, G_TYPE_UINT,
					 G_TYPE_NONE);
}

static void dbusmenu_menuitem_init(DbusmenuMenuitem *self)
{
}

gboolean dbusmenu_menuitem_property_set_int(DbusmenuMenuitem * mi,
					    const gchar * property,
					    const gint value)
{
  return TRUE;
}

gboolean dbusmenu_menuitem_property_set(DbusmenuMenuitem * mi,
					const gchar * property,
					const gchar * value)
{
  return TRUE;
}

gboolean dbusmenu_menuitem_child_delete(DbusmenuMenuitem *mi,
					DbusmenuMenuitem *child)
{
  return TRUE;
}

guint dbusmenu_menuitem_get_position(DbusmenuMenuitem *mi,
				     DbusmenuMenuitem *parent)
{
  return TRUE;
}

gboolean dbusmenu_menuitem_child_add_position(DbusmenuMenuitem *mi,
					      DbusmenuMenuitem *child,
					      guint position)
{
  return TRUE;
}

gboolean dbusmenu_menuitem_property_set_bool(DbusmenuMenuitem *mi,
					     const gchar *property,
					     const gboolean value)
{
  return TRUE;
}

gboolean dbusmenu_menuitem_child_append(DbusmenuMenuitem *mi,
					DbusmenuMenuitem *child)
{
  return TRUE;
}

DbusmenuMenuitem *dbusmenu_menuitem_new(void)
{
  return g_object_new(DBUSMENU_TYPE_MENUITEM, NULL);
}


