""" Slideshow dialog implementation

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: SlideShowDialog.py,v 1.34 2004/02/28 14:08:10 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.34 $"

from string import *
import os                               # in order to delete files
import traceback
import random
import Error

try:
    from qt import *
except:
    Error.qtImportError()

global SizePolicyClass

SizePolicyClass = None

class SlideShowDialog(QDialog):
    def __init__(self,parent,env,sizeMode = "Scale"):
        QDialog.__init__(self,parent)
        self.env = env
        from customWidgets import MouseMoveLabel
        SizePolicyClass = QSizePolicy
        self.setPaletteForegroundColor(QColor(255,255,255))
        self.setPaletteBackgroundColor(QColor(0,0,0))
        self.setSizePolicy(SizePolicyClass(0,0,0,0,self.sizePolicy().hasHeightForWidth()))
        if sizeMode=="Slide":
            self.sv=  QScrollView(self)
            self.pixlabel = MouseMoveLabel(self.sv)
            self.pixlabel.mvCallback = self.onMouseDelta
            self.pixlabel.slideshowDialog = self
            self.sv.setVScrollBarMode(QScrollView.AlwaysOff)
            self.sv.setHScrollBarMode(QScrollView.AlwaysOff)
            self.sv.addChild(self.pixlabel)

            self.vbox = QVBoxLayout(self)
            self.vbox.addWidget(self.sv)
            self.vbox.activate()

        elif sizeMode=="Scale":
            Form1Layout = QGridLayout(self,1,1,11,6,"Form1Layout")

            self.pixlabel = MouseMoveLabel(self)
            self.pixlabel.mvCallback = self.onMouseDelta
            self.pixlabel.slideshowDialog = self

            Form1Layout.addWidget(self.pixlabel,1,1)
            spacer = QSpacerItem(20,121,SizePolicyClass.Minimum,SizePolicyClass.Expanding)
            Form1Layout.addItem(spacer,0,1)
            spacer_2 = QSpacerItem(21,211,SizePolicyClass.Minimum,SizePolicyClass.Expanding)
            Form1Layout.addItem(spacer_2,2,1)
            spacer_3 = QSpacerItem(231,20,SizePolicyClass.Expanding,SizePolicyClass.Minimum) #Minimum
            Form1Layout.addItem(spacer_3,1,0)
            spacer_4 = QSpacerItem(231,20,SizePolicyClass.Expanding,SizePolicyClass.Minimum)
            Form1Layout.addItem(spacer_4,1,2)

        self.seenList = []                # list of imgs already displayed (list of idx's) - see jumpSlide()
        self.slideIdx = 0
        self.doRandom = 0
        #self.apix = QPixmap()
        self.flist = []
        self.mtimer = None
        self.fname = None                 # filename being displayed

        self.doJump = 1                   # whether it should jump automatically when the timer timeouts
        # auto scale options
        self.scaleDown = 1
        self.scaleUp = 0
        # misc init
        self.move(0,0)
        self.showFullScreen()
        self.setMaximumSize(self.frameSize())
        self.setMinimumSize(self.frameSize())
        self.interv = 3500
        #### Popupmenus:
        self.imgmenu = QPopupMenu(self) #the popup for images
        self.imgmenu.insertItem ( "&Random order", self.onRandomMenu,0,5)
        self.imgmenu.insertItem ( "&Jump automatically", self.onJumpMenu,0,6)
        self.imgmenu.insertSeparator()
        self.imgmenu.insertItem ( "Scale &up to fit window", self.onScaleUpMenu,0,7)
        self.imgmenu.insertItem ( "Scale &down to fit window", self.onScaleDownMenu,0,8)
        self.imgmenu.insertSeparator()
        self.imgmenu.insertItem ( self.env.wnd.helpAboutAction.iconSet(),"Show image &information", self.onShowInfoMenu)
        self.imgmenu.insertItem ( "Copy this image to a &group", self.onMoveGroupMenu)
        self.imgmenu.insertItem ( "&Move to another directory", self.onMoveMenu)
        self.imgmenu.insertItem ( self.env.wnd.removedead.iconSet(),"Physically &delete", self.onDeleteMenu)
        self.imgmenu.insertSeparator()
        self.imgmenu.insertItem (self.env.wnd.helpIndexAction.iconSet(),"&Shortcuts help", self.onHelpMenu)
        self.imgmenu.insertSeparator()
        self.imgmenu.insertItem ( self.env.wnd.fileExitAction.iconSet(),"E&xit slideshow", self.close)
        self.imgmenu.setCheckable(1)
        self.imgmenu.setItemChecked(5,1)
        self.imgmenu.setItemChecked(6,1)
        self.imgmenu.setItemChecked(7,0)
        self.imgmenu.setItemChecked(8,1)
        #### show dlg
        self.show()

    def onHelpMenu(self):
        QMessageBox.information( self, "imgSeek - Help","""\
Esc, Q - Stops slideshow
Space - Jump to the next slide or file on the current dir or category
Backspace - Jump to the previous slide or file on the current dir or category

R - Toggles Random jumping
A - Toggles Auto jumping
> - Toggles \"scale down to fit window\" (default = enabled)
< - Toggles \"scale up to fit window\"

I - Show basic image information
G - Copy this image to a group
M - Physically move this image to another directory
D - Delete image (will ask for confirmation)
        """)

    def onRandomMenu(self):
        if self.imgmenu.isItemChecked(5):
            self.imgmenu.setItemChecked(5,0)
            self.doRandom = 0
        else:
            self.imgmenu.setItemChecked(5,1)
            self.doRandom = 1

    def onJumpMenu(self):
        if self.imgmenu.isItemChecked(6):
            self.imgmenu.setItemChecked(6,0)
            self.doJump = 0
        else:
            self.imgmenu.setItemChecked(6,1)
            self.doJump = 1

    def keyPressEvent (self,e):
        if e.key()==Qt.Key_Q:
            self.close()
        if e.key()==Qt.Key_Space:
            self.jumpSlide()
        if e.key()==Qt.Key_Backspace:
            self.jumpSlide(-1)
        if e.key()==Qt.Key_R:
            self.onRandomMenu()
        if e.key()==Qt.Key_I:
            self.onShowInfoMenu()
        if e.key()==Qt.Key_A:
            self.onJumpMenu()
        if e.key()==Qt.Key_G:
            self.onMoveGroupMenu()
        if e.key()==Qt.Key_M:
            self.onMoveMenu()
        if e.key()==Qt.Key_Less:
            self.onScaleUpMenu()
        if e.key()==Qt.Key_Greater:
            self.onScaleDownMenu()
        if e.key()==Qt.Key_F1:
            self.onHelpMenu()
        if e.key()==Qt.Key_D:
            self.onDeleteMenu()
        QDialog.keyPressEvent(self,e)

    def onScaleUpMenu(self):
        if self.imgmenu.isItemChecked(7):
            self.imgmenu.setItemChecked(7,0)
            self.scaleUp = 0
        else:
            self.imgmenu.setItemChecked(7,1)
            self.scaleUp = 1
        self.showImg(self.fname)

    def onScaleDownMenu(self):
        if self.imgmenu.isItemChecked(8):
            self.imgmenu.setItemChecked(8,0)
            self.scaleDown = 0
        else:
            self.imgmenu.setItemChecked(8,1)
            self.scaleDown = 1
        self.showImg(self.fname)

    def onDeleteMenu(self):
        #TODO2: physically removing here will not invoke any db function to see if this file should be removed from dbase
        if self.mtimer: self.mtimer.stop()
        res = QMessageBox.information( self, "imgSeek","Are you sure you want to physically remove \"%s\" ?"%self.fname,   QString("&Delete"), QString("Cancel"))
        if not res:
            os.remove(self.fname)
        if self.mtimer: self.mtimer.start(self.interv)

    def onShowInfoMenu(self):
        if self.mtimer: self.mtimer.stop()
        self.env.curdb.syncFullFilenames()
        infotxt = ""
        infotxt = infotxt+"Filename:%s\n"%self.fname
        try:
            mID = self.env.curdb.fullfilenamedict[self.fname]
            infotxt = infotxt+"Metadata:\n"
            mdict = self.env.curdb.meta[mID]
            for k in mdict:
                infotxt = infotxt+"%s: %s\n"%(k,mdict[k])
        except:
            traceback.print_exc()
            pass
        QMessageBox.information( self, "imgSeek",infotxt)
        if self.mtimer: self.mtimer.start(self.interv)

    def onMoveMenu(self):
        if self.mtimer: self.mtimer.stop()
        filename = str(QFileDialog.getExistingDirectory())
        if filename:
            #if not self.selectedResult: return
            try:
                os.rename(self.fname, filename+self.fname[rfind(self.fname,os.sep)+1:])
            except:
                traceback.print_exc()
                QMessageBox.information(self,"imgSeek","Error moving file.")
        if self.mtimer: self.mtimer.start(self.interv)

    def onMoveGroupMenu(self):
        self.env.curdb.syncFullFilenames()
        try:
            self.curImgID = self.env.curdb.fullfilenamedict[self.fname]
        except:
            QMessageBox.information( self, "imgSeek","Image not found on database. Unable to move between groups.")
            return
        from GroupPickerWnd import GroupPickerWnd
        GroupPickerWnd(self,self.onResultsMoveGroupCB,self.env)

    def onResultsMoveGroupCB(self,gid):
        """ grouppicker will call this fcn when user is done picking a group to move files to"""
        if gid==-1:return
        if not self.env.curdb.moveObjectsToGroup([{"type":"Img","id":self.curImgID}],gid):
            QMessageBox.information(self,"imgSeek","Error moving file to group.")

    def showImg(self,fname):
        """if resz = 1, then the dlg will autoresize to images size
        """
        if not os.path.exists(fname):
            QMessageBox.information( self, "imgSeek","File not found:"+fname)
            print "File not found:"+fname
            return
        apix = None
        hasToConv = 0
        if self.scaleDown or self.scaleUp: # open as image, as a scale op is very probable
            hasToConv = 1
            apix = self.env.curdb.openImage(fname)
        else:
            hasToConv = 1
            self.apix = self.env.curdb.openPixmap(fname)
        self.fname = fname
        self.setCaption(fname)
        if self.scaleDown and (apix.width()>self.width() or apix.height()>self.height()) :
            apix = apix.smoothScale(self.width()-34,self.height()-34,QImage.ScaleMin)
            self.apix = QPixmap()
            self.apix.convertFromImage(apix)
            hasToConv = 0
        if self.scaleUp and (apix.width()<self.width() or apix.height()<self.height()):
            apix = self.apix.convertToImage()
            apix = apix.smoothScale(self.width()-34,self.height()-34,QImage.ScaleMin)
            self.apix.convertFromImage(apix)
            hasToConv = 0
        if hasToConv: self.apix = self.env.curdb.openPixmap(fname)
        self.pixlabel.setPixmap(self.apix)
        # apply view transforms as told by metadata
        fid = -10
        try:                            # try to find out this image's id. It will obviously fail if its not even on db
            fid = self.env.curdb.fullfilenamedict[self.fname]
        except:
            pass
        else:
            if self.env.curdb.meta.has_key(fid):
                if self.env.curdb.meta[fid].has_key("ViewRotate"):
                    self.pixlabel.doRotate(int(self.env.curdb.meta[fid]["ViewRotate"]))


    def onMouseDelta(self,delta):
        try:
            self.sv.scrollBy(-delta[0],-delta[1])
        except:
            pass

    def start(self,interv = 3500):
        self.interv = interv
        if not len(self.flist): return
        self.mtimer = QTimer(self)
        self.connect( self.mtimer, SIGNAL("timeout()"), self.onmTimer )
        self.mtimer.start(interv)
        self.onmTimer()
        if not self.interv: self.doJump = 0

    def jumpSlide(self,step = 1):
        if not len(self.flist): return
        if len(self.seenList) >= len(self.flist)-2:
            self.seenList = []            # reset list of seen list, allowing imgSeek to show them all once again
        if self.doRandom:
            idx = random.randrange(0,len(self.flist)-1)
            if idx in self.seenList:
                self.jumpSlide(step)
                return
        else:
            self.slideIdx = self.slideIdx+step
            if self.slideIdx>=len(self.flist): self.slideIdx = 0
            if self.slideIdx<0 : self.slideIdx = len(self.flist)-1
            idx = self.slideIdx
        self.seenList.append(idx)
        self.showImg(self.flist[idx])

    def onmTimer(self):
        if self.doJump:
            self.jumpSlide()

    def closeEvent(self,e):
        if self.mtimer:
            self.mtimer.stop()
        QDialog.closeEvent(self,e)

    def hideEvent(self,e):
        if self.mtimer:
            self.mtimer.stop()
        QDialog.hideEvent(self,e)

    def mousePressEvent(self,e):
        self.pixlabel.mousePressEvent(e)
        QDialog.mousePressEvent(self,e)
