""" Metadata editor implementation

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: MetaWnd.py,v 1.34 2003/12/24 18:34:47 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.34 $"

from string import *
import Error

try:
    from qt import *
except:
    Error.qtImportError()

try:
    from qttable import QTable,QComboTableItem,QTableItem
except:
    print "Unable to import some QT table modules. Metadata editing may not work"

try:
    from MetaForm import *
except:
    print "MetaWnd: Unable to import some imgSeek modules. Some features will not work."

class MetaWnd(metaform):
    def __init__(self, parent,env,ifile = None):
        self.env = env
        self.curdb = self.env.curdb
        metaform.__init__(self, parent)
        self.imgIdx = 0
        self.curfid = None
        #popup
        self.fieldMenu = QPopupMenu(self)
        self.fieldMenu.insertItem ( parent.fileNewAction.iconSet(),"&New parameter", self.onNewField)
        self.fieldMenu.insertItem ( parent.removedead.iconSet(), "&Remove parameter", self.onDelField)
        self.fieldMenu.insertSeparator()
        self.fieldMenu.insertItem ( parent.removedead.iconSet(), "Remove &ALL parameters", self.onDelAllField)
        # other inits
        self.metalist = None
        self.combos = []
        self.selectedRow = None
        self.tableMeta.setColumnStretchable(1,1)
        self.readonlyfields = self.curdb.readonlyfields
        self.updateCombos()
        self.dirty = 0
        self.onImage = 1
        self.curdb.cbs["Batch"].append(self.syncBatchCombo)
        if ifile:                       # requested file to be shown immediately
            self.showFile(ifile)
        else:                           #simple show first file on dbase
            self.showFile(self.curdb.meta.keys()[0])
        self.syncBatchCombo()
    def onNewField(self):
        if not self.onImage:
            self.onNewFieldBatch()
            return
        text = "New field"
        self.tableMeta.setNumRows(self.tableMeta.numRows()+1)
        if text not in self.curdb.metafields:
            self.curdb.metafields.append(text)
            self.updateCombos()
        a = QComboTableItem ( self.tableMeta, self.metalist, 1 )
        a.setCurrentItem(text)
        self.combos.append(a)
        self.tableMeta.setItem(self.tableMeta.numRows()-1,0,a)

    def onNewFieldBatch(self):
        """adding new field while on batch mode """
        text = "New field"
        self.tableMeta.setNumRows(self.tableMeta.numRows()+1)
        a = QComboTableItem ( self.tableMeta, self.metalist, 1 )
        a.setCurrentItem(text)
        self.combos.append(a)
        self.tableMeta.setItem(self.tableMeta.numRows()-1,0,a)

    def onDelField(self):
        self.tableMeta.removeRow(self.selectedRow)
        if self.onImage:
            self.saveMeta()

    def onDelAllField(self):
        if self.onImage:
            self.curdb.removeAllMeta(self.curfid)
            self.showFile(self.curfid)
        else:
            self.tableMeta.setNumRows(0)

    def tableMeta_currentChanged(self,a0,a1):
        return                          # do not save on every single move
        if self.targettab.currentPageIndex() == 0: # image
            self.saveMeta()

    def updateCombos(self):
        """sync all combos to the metafields cache at curdb.metafields """
        if not len(self.curdb.metafields): return
        lst = QStringList()
        for mtf in self.curdb.metafields:
            if mtf not in self.readonlyfields and mtf not in self.curdb.invisiblefields:
                lst.append(mtf)
        for cmb in self.combos:
            cmb.setStringList(lst)
        self.metalist = lst

    def showMetaTable(self,tbl):
        cnt = 0
        for cmb in self.combos: del cmb
        self.combos = []
        kes = tbl.keys()[:]
        kes.sort()
        hidcnt = 0
        for hidfld in self.curdb.invisiblefields:
            if hidfld in kes: hidcnt = hidcnt+1
        self.tableMeta.setNumRows(len(tbl)-hidcnt)
        for field in kes:
            if field not in self.curdb.metafields:
                self.curdb.metafields.append(field)
                self.updateCombos()
        for field in kes:
            if field in self.curdb.invisiblefields: continue
            if field in self.readonlyfields:
                try:
                    self.tableMeta.setItem(cnt,1,QTableItem ( self.tableMeta,QTableItem.Never, str(tbl[field])))
                    self.tableMeta.setItem(cnt,0,QTableItem ( self.tableMeta,QTableItem.Never, field))
                except:
                    Error.PrintTB()
            else:
                a = QComboTableItem ( self.tableMeta, self.metalist, 1 )
                self.combos.append(a)
                self.tableMeta.setItem(cnt,0,a)
                self.tableMeta.setItem(cnt,1,QTableItem ( self.tableMeta,QTableItem.Always, str(tbl[field])))
                a.setCurrentItem(field)
            cnt = cnt+1

    def showFile(self,fid):
        self.imgIdx = self.curdb.img.keys().index(fid)
        self.curfid = fid
        self.showMetaTable(self.curdb.meta[fid])
        self.thumbLabel.setPixmap(QPixmap(self.curdb.getThumbDB(fid)))
        self.indexLabel.setText(str(self.imgIdx+1)+" / "+str(len(self.curdb.img.keys())))

    def saveMeta(self):
        """save metadata for currently shown image. Called by prev/next/apply"""
        self.curdb.meta[self.curfid] = {}
        dct = self.metaFromTable()
        for fi in dct.keys():
            self.curdb.meta[self.curfid][fi] = dct[fi]
        self.curdb.dirty = 1
        self.dirty = 0

    def metaFromTable(self):
        """ returns a meta dict from whats currently on the table"""
        dct = {}
        savedfields = []
        for ri in range(self.tableMeta.numRows()):
            try:
                if str(self.tableMeta.text(ri,0)) in savedfields:
                    continue
                savedfields.append(str(self.tableMeta.text(ri,0)))

                ### Convert field title and data to iso-8859-1 before storing on db
                field_uc = self.tableMeta.text(ri,0)
                try:
                    field_uc=str(field_uc)
                except:
                    try:
                        field_uc=unicode(field_uc).encode("iso-8859-1")
                    except:
                        Error.PrintTB()
                        t="Invalid char in string."

                data_uc = self.tableMeta.text(ri,1)
                try:
                    data_uc=str(data_uc)
                except:
                    try:
                        data_uc = unicode(data_uc).encode("iso-8859-1")
                    except:
                        Error.PrintTB()
                        t="Invalid char in string"
                dct[field_uc] = data_uc
            except:
                Error.PrintTB()
                print "Error saving metadata field:"+str(ri)
        return dct

    def previousBtn_clicked(self):
        self.saveMeta()
        self.imgIdx = self.imgIdx-1
        if self.imgIdx<0:self.imgIdx = len(self.curdb.meta.keys()) -1
        self.showFile(self.curdb.meta.keys()[self.imgIdx])

    def nextButton_clicked(self):
        self.saveMeta()
        self.imgIdx = self.imgIdx+1
        if self.imgIdx>=len(self.curdb.meta.keys()):
            self.imgIdx = 0
        self.showFile(self.curdb.meta.keys()[self.imgIdx])

    def syncBatchCombo(self,what = None):
        """call it to sync curdb batch list to what the ui shows """
        self.batchcombo.clear()
        for bid in self.curdb.batches.keys():
            self.batchcombo.insertItem(self.curdb.batches[bid][0])

    def ApplyBtn_clicked(self):
        if self.targettab.currentPageIndex() == 0: # image
            self.saveMeta()
        else:                           # batch
            try:
                self.batchmtable = self.metaFromTable()
                bid = self.curdb.batches.keys()[self.batchcombo.currentItem()]
                self.curdb.saveBatchMeta(self.batchmtable,bid)
            except:
                Error.PrintTB()
                print "Error saving setting metadata to batch of images"

    def tableMeta_contextMenuRequested(self,a0,a1,a2):
        self.selectedRow = a0
        self.fieldMenu.popup(a2)

    def targettab_selected(self,a0):
        pass

    def targettab_currentChanged(self,a0):
        if self.targettab.currentPageIndex() == 0: # image
            self.thumbLabel.show()
            self.onImage = 1
            self.showFile(self.curfid)
        else:                           # batch
            self.saveMeta()
            self.onImage = 0
            self.thumbLabel.hide()
            self.showMetaTable({})

    def showbatcheditor_clicked(self):
        wnd = self.parent()
        wnd.editcategaction_activated()

    def batchcombo_activated(self,a0):
        pass

    def refreshbtn_clicked(self):
        res = QMessageBox.information( self, "imgSeek","Are you sure you want to revert to saved metadata and lose changes you made to the current image ?",   QString("&Revert to what is saved"), QString("Cancel"))
        if res: return
        self.showFile(self.curfid)

    def closeEvent(self,e):
        if not self.dirty:
            metaform.closeEvent(self,e)
            return
        res = QMessageBox.information( self, "imgSeek","Do you want to save changes made to current image ?",   QString("&Save"), QString("&Discard"))
        metaform.closeEvent(self,e)
        if res: return
        self.saveMeta()

    def tableMeta_valueChanged(self,a0,a1):
        self.dirty = 1
