#include <stdio.h>
#include <string.h>

#include "imapfilter.h"
#include "session.h"
#include "queue.h"


extern struct sessionhead sessions;


/*
 * Allocate memory for a new session and add it to the sessions linked list.
 */
session_t *
session_new(void)
{
	session_t *s;

	s = (session_t *) xmalloc(sizeof(session_t));

	session_init(s);

	XLIST_INSERT_HEAD(&sessions, s, links);

	return s;
}


/*
 * Set session variables to safe values.
 */
void
session_init(session_t * ssn)
{
	ssn->server = NULL;
	ssn->username = NULL;
	ssn->socket = -1;
#ifndef NO_SSLTLS
	ssn->ssl = NULL;
#endif
	ssn->protocol = PROTOCOL_NONE;
	ssn->capabilities = CAPABILITY_NONE;
	ssn->ns.prefix = NULL;
	ssn->ns.delim = '\0';
}


/*
 * Remove session from sessions linked list.
 */
void
session_destroy(session_t * ssn)
{
	XLIST_REMOVE(ssn, links);

	session_free(ssn);
}


/*
 * Free session allocated memory.
 */
void
session_free(session_t * ssn)
{

	if (ssn->server)
		xfree(ssn->server);
	if (ssn->username)
		xfree(ssn->username);
	if (ssn->ns.prefix)
		xfree(ssn->ns.prefix);
	xfree(ssn);
}


/*
 * Based on the specified socket, find an active IMAP session.
 */
session_t *
session_find(const char *serv, const char *user)
{
	session_t *s;

	XLIST_FOREACH(s, &sessions, links)
	    if (!strncmp(s->server, serv, strlen(serv)) &&
	    !strncmp(s->username, user, strlen(user)))
		break;

	return s;
}
