-- date_before()
function date_before(days)
	checktype_aux(days, 'number')

	return os.date("%d-%b-%Y", os.time() - days * 60 * 60 * 24)
end

-- get_pass()
function get_pass(prompt)
	if (prompt ~= nil) then
		io.write(prompt)
	else
		io.write('Password: ')
	end

	os.execute('stty -echo echonl')
	local pass = io.read()
	os.execute('stty echo -echonl')

	return pass
end

-- pipe_to()
function pipe_to(command, data)
	checktype_aux(command, 'string')
	checktype_aux(data, 'string')

	f = ifsys.popen(command, "w")

	ifsys.write(f, data)

	return ifsys.pclose(f)
end

-- pipe_from()
function pipe_from(command)
	checktype_aux(command, 'string')

	f = ifsys.popen(command, "r")

	local string = ''
	while (true) do
		s = ifsys.read(f)
		if (s ~= nil) then
			string = string .. s
		else
			break
		end
	end

	return ifsys.pclose(f), string
end

-- daemon_mode()
function daemon_mode(interval, commands)
	checktype_aux(interval, 'number')
	checktype_aux(commands, 'function')

	ifsys.daemon()

	repeat
		pcall(commands)
	until (ifsys.sleep(interval) ~= 0)
end
