/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "ihistogram.h"


#include "ierror.h"
#include "ihistogrammaker.h"

//
//  Templates
//
#include "iarraytemplate.h"


iHistogram* iHistogram::New(iViewModule *vm, iHistogramMaker *parent)
{
	IERROR_ASSERT(vm);  // parent can be zero
	return new iHistogram(vm,parent);
}


iHistogram::iHistogram(iViewModule *vm, iHistogramMaker *parent) : iPiecewiseFunction(0.0f,1.0f,100), mViewModule(vm), mPosMin(vm), mPosMax(vm)
{
	mParent = parent;

	mStretch = 0;

	mValMin = mValMax = 0.0;
	mCellMin = mCellMax= -1;
}


iHistogram::~iHistogram()
{
}


void iHistogram::Copy(const iHistogram *h)
{
	iPiecewiseFunction::Copy(h);

	mStretch = h->mStretch;

	mValMin = h->mValMin;
	mValMax = h->mValMax;

	mCellMin = h->mCellMin;
	mCellMax = h->mCellMax;

	mPosMin = h->mPosMin;
	mPosMax = h->mPosMax;
}


void iHistogram::SetData(int n, float *values)
{
	int i;

	mArr.Resize(n+2);
	mArr[0].X = 0.0f;
	mArr[0].Y = 0.0f;

	Point *ptr = const_cast<Point*>(mArr.Data()) + 1;
	for(i=0; i<n; i++)
	{
		ptr[i].X = (i+0.5)/n;
		ptr[i].Y = values[i];
	}

	this->MovePoint(n+1,1.0f,0.0f);
}

