/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iviewsubjectpipeline.h"


#include "ierror.h"

#include <vtkDataSet.h>
#include <vtkPolyData.h>

//
//  Templates
//
#include "iarraytemplate.h"
#include "igenericfiltertemplate.h"



iViewSubjectPipeline::iViewSubjectPipeline(iViewSubject *vo, int numInputs) : iGenericFilter<vtkDataSetToPolyDataFilter,vtkDataSet,vtkPolyData>(vo,numInputs,true,true)
{
	mGlobalInput = 0;
}


iViewSubjectPipeline::~iViewSubjectPipeline()
{
	this->SetGlobalInput(0);
	while(mInternalFilters.Size() > 0) mInternalFilters.RemoveLast()->Delete();
}


void iViewSubjectPipeline::SetGlobalInput(vtkDataSet *input)
{
	if(mGlobalInput != 0)
	{
		mGlobalInput->UnRegister(this);
	}

	mGlobalInput = input;
	
	if(mGlobalInput != 0)
	{
		mGlobalInput->Register(this);
	}
	
	this->Modified();
}


float iViewSubjectPipeline::GetMemorySize()
{
	return this->iGenericFilter<vtkDataSetToPolyDataFilter,vtkDataSet,vtkPolyData>::GetMemorySize() + this->GetContentsMemorySize();
}


//
//  Permitted Input/Output access
//
void iViewSubjectPipeline::SetNthInput(int num, vtkDataObject *input)
{
	this->iGenericFilter<vtkDataSetToPolyDataFilter,vtkDataSet,vtkPolyData>::SetNthInput(num,input);
}


void iViewSubjectPipeline::RemoveInternalData(bool keepOutputs)
{
	int i, j;
	for(i=0; i<mInternalFilters.Size(); i++)
	{
#ifdef IVTK_44
		for(j=0; j<mInternalFilters[i]->GetNumberOfOutputs(); j++) mInternalFilters[i]->GetOutputs()[j]->Initialize();
#else
		for(j=0; j<mInternalFilters[i]->GetNumberOfOutputPorts(); j++) mInternalFilters[i]->GetOutputDataObject(j)->Initialize();
#endif
	}
	if(!keepOutputs)
	{
		for(i=0; this->GetNumberOfOutputs(); i++) this->GetOutput(i)->Initialize();
	}
	this->RemoveInternalDataForExtraComponents(keepOutputs);
}


void iViewSubjectPipeline::RemoveInternalDataForExtraComponents(bool)
{
	//
	//  By default we have no non-filter components
	//
}

