/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IRULER_H
#define IRULER_H


#include <vtkAxisActor2D.h>


#include "ipointermacro.h"
#include "istring.h"

class iOverlayHelper;
class iRenderTool;
class iViewModule;


class iRuler: public vtkAxisActor2D
{
	
	IPOINTER_AS_PART(ViewModule);
	IPOINTER_AS_USER(OverlayHelper);

public:
	
	vtkTypeMacro(iRuler,vtkAxisActor2D);
	static iRuler* New(iViewModule *vm = 0);
	
	virtual int RenderOverlay(vtkViewport *vp);
	virtual int RenderOpaqueGeometry(vtkViewport *vp);
	virtual int RenderTranslucentGeometry(vtkViewport * ){ return 0; }
	
	virtual void ReleaseGraphicsResources(vtkWindow *win);

	void SetBaseScale(float s);

	void SetScale(float s);
	inline float GetScale() const { return mScale; }

	void SetTitle(const iString &title);
	inline const iString& GetTitle() const { return mTitle; }

protected:

	virtual ~iRuler();

private:
	
	iRuler(iViewModule *vm);
	
	float mLineWidth;
	int mTickLength;
	float mDx;

	bool mStarted;
	float mScale, mBaseScale;
	iString mTitle;
};

#endif // IRULER_H
