/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Header file for iCrossSectionViewSubject class
//

#ifndef ICROSSSECTIONVIEWSUBJECT_H
#define ICROSSSECTIONVIEWSUBJECT_H


#include "isolidviewsubject.h"


class vtkImageData;
class vtkTexture;


class iCrossSectionViewSubject : public iSolidViewSubject 
{
	
	friend class iAbstractExtension;
	friend class iObjectFactory;

public:
	
	vtkTypeMacro(iCrossSectionViewSubject,iSolidViewSubject);
	static const iObjectType& Type();
		
	IOBJECT_DECLARE_GETSET1(Dir,int);
//	virtual void SetDir(int d);
//	inline int GetDir() const { return mDir; }

	IOBJECT_DECLARE_GETSET(Var,mVar,int);
//	virtual void SetVar(int v);
//	inline int GetVar() const { return mVar; }

	IOBJECT_DECLARE_GET1(OverTheEdgeFlag,bool);
//	inline int GetOverTheEdgeFlag() const { return mOverTheEdgeFlag; }

	IOBJECT_DECLARE_GETSET1(SampleRate,int);
//	virtual void SetSampleRate(int p);
//	inline int GetSampleRate() const { return mSampleRate };

	IOBJECT_DECLARE_GETSET1(Method,int);
//	virtual void SetMethod(int m);
//	inline int GetMethod() const { return mMethod; }

	IOBJECT_DECLARE_GETSET1(InterpolateData,bool);
//	virtual void SetInterpolateData(bool s);
//	inline bool GetInterpolateData(){ return mInterpolateData; }

	virtual void SetLocation(double p);
	virtual void SetLocation(const iDistance &p);
	inline double GetLocation() const { return mPosition[mDir]; }
	static const iObjectKey& KeyLocation(bool opengl = false);

	//
	//  Action keys
	//
	virtual void PlaceAtSpecialLocation(int n);
	static const iObjectKey& KeySpecialLocation();

//	inline vtkLookupTable* GetColorLookupTable() const { return mColorLookupTable; }
	inline vtkImageData* GetTextureData() const { return mTextureData; }
	
	void ForcePolygonalMethod(bool s);

	inline int GetActualMethod() const { if(mForcePolygonalMethod) return 0; else return mMethod; }

	//
	//  Inherited members
	//
	virtual iViewSubjectPipeline* CreatePipeline(int id);
	ISOLIDVIEWSUBJECT_DECLARE_INHERITED_KEYS;
	ISOLIDVIEWSUBJECT_DECLARE_INHERITED_MEMBERS;

protected:
	
	iCrossSectionViewSubject(iViewModule *vm, const iDataType &type, const iString &name);
	virtual ~iCrossSectionViewSubject();
	virtual void ConfigureBody();
	virtual void ConfigureMainPipeline(iViewSubjectPipeline *p, int id);

	virtual void FinishInitialization();
	virtual float GetExtraMemorySize() const;
	virtual void RemoveInternalDataForExtraComponents();	

	void UpdateTextureSize();
	virtual void UpdatePosition(const iPosition &oldPos);

	bool mInterpolateData, mOverTheEdgeFlag;

	int mVar, mDir, mMethod, mSampleRate;
	bool mForcePolygonalMethod;
	//
	//  VTK stuff
	//
	vtkTexture *mTexture;
	vtkImageData *mTextureData;
};

#endif // ICROSSSECTIONVIEWSUBJECT_H

