/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "icalculatorkit.h"


namespace iCalculatorKit
{
	//
	//  Handle
	//
	Handle::Handle(const iString &name) : mName(name), mVar(0)
	{
	}	
	

	Handle::Handle(Variable *v) : mName(v->Name()), mVar(v)
	{
	}


	void Handle::Attach(const Variable *v)
	{
		if(mVar==0 && v!=0)
		{
			mVar = const_cast<Variable *>(v);  //  take away constness since handles also control internal, changeable variables
			mName = v->Name();
		}
	}


	//
	//  Variable
	//
	Variable::Variable(int dim, int use, const iString &name) : mDim(dim), mUse(use), mName(name)
	{
	}


	Variable::~Variable()
	{
	}


	bool Variable::Copy(const Variable &var)
	{
		if((mDim!=var.mDim || mUse!=var.mUse) && !this->Morph(var.mDim,var.mUse)) return false;
		this->CopyBody(var);
		return true;
	}

	
	bool Variable::Morph(int dim, int use)
	{
		if(!this->MorphBody(dim,use)) return false;
		mDim = dim;
		mUse = use;
		return true;
	}


	//
	//  Function
	//
	Function::Function(Variable *result, int narg, int loc) : mResult(result), mNumArgs(narg), mDataLoc(loc)
	{
	}


	Function::~Function()
	{
	}


	void Function::SetNumArguments(int narg)
	{
		if(mNumArgs < 0) mNumArgs = narg;
	}
};

