/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iqtshellsubject.h"


#include "ierror.h"
#include "ishell.h"
#include "istring.h"

#include "iqt.h"

#include <vtkIOStream.h>

#ifdef IQT_3
#include <qapplication.h>
#include <qmessagebox.h>
#else
#include <QtGui/QApplication>
#include <QtGui/QDesktopWidget>
#include <QtGui/QMessageBox>
#ifdef Q_WS_X11
#include <QtGui/QX11Info>
#endif
#endif


iqtShellSubject::iqtShellSubject(iggShell *owner, int argc, char **argv) : ibgShellSubject(owner,argc,argv)
{
	new QApplication(argc,argv);

	//
	//  Test that Qt is compiled with RTTI 
	//
	QWidget *pp = new QMessageBox();
	if(pp == 0)
	{
		IERROR_FATAL("There is not enough memory to run IFrIT.");
		exit(0);
	}
	QMessageBox *ps = dynamic_cast<QMessageBox*>(pp);
	if(ps == 0)
	{
		IERROR_FATAL("Qt has not been compiled with the RTTI (Run-Time Type Information) support.\nIFrIT needs all components to be compiled with the RTTI support.\nPlease re-compile Qt with the RTTI support enabled.");
		delete qApp;
		exit(0);
	}
	delete ps;
}


iqtShellSubject::~iqtShellSubject()
{
	delete qApp;
}


void iqtShellSubject::Exit()
{
	qApp->quit();
}


void iqtShellSubject::GetDesktopDimensions(int &w, int &h) const
{
	w = qApp->desktop()->width();
	h = qApp->desktop()->height();
}


void iqtShellSubject::ProcessEvents(bool sync)
{
	qApp->flush();
	if(sync) qApp->syncX();
	qApp->sendPostedEvents();
	qApp->processEvents();
}


void iqtShellSubject::CompleteStartUp()
{
	qApp->connect(qApp,SIGNAL(lastWindowClosed()),qApp,SLOT(quit()));
}


void iqtShellSubject::EnterEventLoop()
{
	//
	//  Just run the Qt Application
	//
	qApp->exec();
}

//
//  Shell capabilities
//
bool iqtShellSubject::CanRecognize8BitDisplay(bool check) const
{
#ifdef Q_WS_X11
	if(!check) return true;
	//
	//  Check for the 8-bit display
	//
#ifdef IQT_3
	return (QPaintDevice::x11AppDepth() < 16);
#else
	return (QX11Info::appDepth() < 16);
#endif
#else
	return false;
#endif
}


bool iqtShellSubject::CanDockWindows() const
{
	return true;
}


bool iqtShellSubject::CanChangeFontSize() const
{
	return true;
}


bool iqtShellSubject::IsWindowManagerModern() const
{
	return true;  // seems not possible to discover from Qt?
}

