/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggwidgetkeybutton.h"


#include "icontrolmodule.h"
#include "ishell.h"

#include "iggframe.h"
#include "iggmainwindow.h"

#include "ibgwidgetbuttonsubject.h"

#include "iggsubjectfactory.h"
#include "iggparameter.h"
using namespace iggParameter;
using namespace iParameter;

//
// Templates
//
#include "iggwidgetkeyhandlertemplate.h"


//
//******************************************
//
//  Generic button
//
//******************************************
//
iggWidgetKeyButton::iggWidgetKeyButton(int type, const iString &text, const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyHandler<bool>(_WidgetTypeOther,key,_RenderModeImmediate,parent,index,indkey)
{
	mSubject = iggSubjectFactory::CreateWidgetButtonSubject(this,type,text,1);
	mReverse = false;
}


void iggWidgetKeyButton::SetReverse(bool s)
{
	mReverse = s;
}


void iggWidgetKeyButton::QueryValue(bool &val) const
{
	val = mSubject->IsDown();
	if(mReverse) val = !val;
}


void iggWidgetKeyButton::UpdateValue(bool val)
{
	if(mReverse) val = !val;
	mSubject->SetDown(val);
}


void iggWidgetKeyButton::OnVoid1Body()
{
	this->ExecuteControl(true);
}


//
//******************************************
//
//  CheckBox
//
//******************************************
//
iggWidgetKeyCheckBox::iggWidgetKeyCheckBox(const iString &text, const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyButton(_ButtonTypeCheckBox,text,key,parent,index,indkey)
{
}


//
//******************************************
//
//  PushButton for 'action' keys
//
//******************************************
//
iggWidgetKeyExecButton::iggWidgetKeyExecButton(const iString &text, const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyButton(_ButtonTypePushButton,text,key,parent,index,indkey)
{
}


void iggWidgetKeyExecButton::UpdateWidgetBody()
{
	//
	//  Nothing to update
	//
}


void iggWidgetKeyExecButton::QueryValue(bool &val) const
{
	val = true;
}


//
//******************************************
//
//  ToolButton (a small PushButton) for 'action' keys
//
//******************************************
//
iggWidgetKeyToolButton::iggWidgetKeyToolButton(const iString &text, const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyButton(_ButtonTypeToolButton,text,key,parent,index,indkey)
{
}


void iggWidgetKeyToolButton::UpdateWidgetBody()
{
	//
	//  Nothing to update
	//
}


void iggWidgetKeyToolButton::QueryValue(bool &val) const
{
	val = true;
}


//
//******************************************
//
//  Toggle (tool) button
//
//******************************************
//
iggWidgetKeyToggleButton::iggWidgetKeyToggleButton(const iImage *icon, const iString &text, const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyButton(_ButtonTypeToggleButton,text,key,parent,index,indkey), mIcon(icon)
{
	if(icon != 0) mSubject->SetIcon(*icon);
}

//
//******************************************
//
//  Special PushButton for loading file names
//
//******************************************
//
iggWidgetKeyFileNameButton::iggWidgetKeyFileNameButton(const iString &text, const iString &header, const iString &selection, const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyHandler<iString>(_WidgetTypeOther,key,_RenderModeImmediate,parent,index,indkey)
{
	mSubject = iggSubjectFactory::CreateWidgetButtonSubject(this,_ButtonTypeToolButton,text,1);

	mHeader = header;
	mSelection = selection;
	mDefault = this->GetMainWindow()->GetShell()->GetEnvironment(_EnvironmentBase);
}


void iggWidgetKeyFileNameButton::SetDefaut(const iString &s)
{
	mDefault = s;
}


void iggWidgetKeyFileNameButton::UpdateWidgetBody()
{
	//
	//  Nothing to update
	//
}


void iggWidgetKeyFileNameButton::QueryValue(iString &val) const
{
	val = this->GetMainWindow()->GetFileName(mHeader,this->GetMainWindow()->GetShell()->GetEnvironment(_EnvironmentBase),"Images (*.jpg *.jpeg *.pnm *.bmp *.png *.tif *.tiff)");
}


void iggWidgetKeyFileNameButton::UpdateValue(iString)
{
}


void iggWidgetKeyFileNameButton::OnVoid1Body()
{
	this->ExecuteControl(true);
}


//
//******************************************
//
//  Exec button for an int-valued key
//
//******************************************
//
iggWidgetKeyExecIntButton::iggWidgetKeyExecIntButton(int value, const iString &text, const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyHandler<int>(_WidgetTypeOther,key,_RenderModeImmediate,parent,index,indkey)
{
	mSubject = iggSubjectFactory::CreateWidgetButtonSubject(this,_ButtonTypePushButton,text,1);
	mValue = value;
}


void iggWidgetKeyExecIntButton::QueryValue(int &val) const
{
	val = mValue;
}


void iggWidgetKeyExecIntButton::UpdateWidgetBody()
{
	//
	//  Nothing to update
	//
}


void iggWidgetKeyExecIntButton::UpdateValue(int)
{
	//
	//  Nothing to update
	//
}


void iggWidgetKeyExecIntButton::OnVoid1Body()
{
	this->ExecuteControl(true);
}



