/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggframeboxsize.h"


#include "ierror.h"
#include "iviewmodule.h"

#include "iggwidgetkeybutton.h"
#include "iggwidgetkeylineedit.h"

#include "iggparameter.h"
using namespace iggParameter;

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"


namespace iggFrameBoxSize_Private
{
	
	class LineEdit : public iggWidgetKeyFloatLineEdit
	{
		
	public:
		
		LineEdit(const iString &label, const iObjectKey &key, iggFrameBoxSize *parent) : iggWidgetKeyFloatLineEdit(label,key,_RenderModeUseGlobal,parent)
		{
			mRealParent = parent;
		}

	protected:

		virtual void OnVoid1Body()
		{
			iggWidgetKeyFloatLineEdit::OnVoid1Body();
			if(mRealParent != 0)
			{
				mRealParent->UpdatePositions();
			}
		}

		virtual void OnString1Body(const iString &s)
		{
			iggWidgetKeyFloatLineEdit::OnString1Body(s);
			if(mRealParent!=0 && this->GetRenderMode()==_RenderModeImmediate)
			{
				mRealParent->UpdatePositions();
			}
		}

	private:

		iggFrameBoxSize *mRealParent;
	};
	

	class CheckBox : public iggWidgetKeyCheckBox
	{
		
	public:
		
		CheckBox(const char* text, const iObjectKey &key, iggFrameBoxSize *parent) : iggWidgetKeyCheckBox(text,key,parent)
		{
			mRealParent = parent;
			mBuddy = 0;
		}

		void SetBuddy(LineEdit *buddy)
		{
			mBuddy = buddy;
			this->UpdateWidget();
			this->UpdateBuddy();
		}

	protected:

		void UpdateBuddy()
		{
			if(mBuddy != 0)
			{
				bool val;
				this->QueryValue(val);
				mBuddy->Enable(!val);
				mBuddy->UpdateWidget();
			}
		}

		virtual void OnVoid1Body()
		{
			iggWidgetKeyCheckBox::OnVoid1Body();
			this->UpdateBuddy();
			if(mRealParent != 0)
			{
				mRealParent->UpdatePositions();
			}
		}

	private:

		iggFrameBoxSize *mRealParent;
		LineEdit *mBuddy;
	};
	
};


using namespace iggFrameBoxSize_Private;


iggFrameBoxSize::iggFrameBoxSize(iggFrame *parent) : iggFrame("Coordinates",parent,1)
{
	CheckBox *cb = new CheckBox("Use OpenGL coordinates",iViewModule::KeyOpenGLCoordinates(),this);
	LineEdit *le = new LineEdit("Box size",iViewModule::KeyBoxSize(),this);
	cb->SetBuddy(le);

	this->AddLine(cb);
	this->AddLine(le);
}


void iggFrameBoxSize::UpdatePositions()
{
	int i;
	iPointerArray<iggWidgetKeyHandlerBase> &list = iggWidgetKeyHandlerBase::PositionList();

	for(i=0; i<list.Size(); i++)
	{
		list[i]->UpdateWidget();
	}
}

