/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#include "iextensionfactory.h"


//
//  This file is documented only partially.
//
#include "ianimatorscript.h"
#include "irendertool.h"


#if IEXTENSION_INCLUDED(IEXTENSION_MV)
#include "imultiviewrendertool.h"
#endif

#if IEXTENSION_INCLUDED(IEXTENSION_HART)
#include "hanimatorscript.h"
#endif


iAnimatorScript* iExtensionFactory::CreateAnimatorScript(iAnimator *animator)
{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	return new hAnimatorScript(animator);
#else
	return new iAnimatorScript(animator);
#endif
}


iRenderTool* iExtensionFactory::CreateRenderTool(iViewModule *vm)
{
#if IEXTENSION_INCLUDED(IEXTENSION_MV)
	return new iMultiViewRenderTool(vm);
#else
	return new iRenderTool(vm);
#endif
}

