/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Methods for outputing error messages
//

#ifndef IOUTPUTWINDOW_H
#define IOUTPUTWINDOW_H


#include <vtkOutputWindow.h>
#include "ishellcomponent.h"


#include "iarray.h"
#include "istring.h"

class iShell;

class vtkCriticalSection;

//
//  Take over VTK display function to prevent it from displaying extra windows
//

class iOutputWindow : public vtkOutputWindow, public iShellComponent
{
	
	friend class iShellFactory;

public:
	
	static iOutputWindow* New(iShell *);

	//
	//  Don't inherit those, they are NOT thread-safe
	//
	virtual void DisplayText(const char*);
	virtual void DisplayErrorText(const char*);
	virtual void DisplayWarningText(const char*);
	virtual void DisplayDebugText(const char*);
	virtual void DisplayGenericWarningText(const char*);
	
	inline void SetErrorMessageFirstSymbol(int n){ mErrorMessageFirstSymbol = n; }
	inline int GetErrorMessageFirstSymbol() const { return mErrorMessageFirstSymbol; }

	inline void SetErrorMessageFirstString(char *s){ mErrorMessageFirstString = s; }
	inline char *GetErrorMessageFirstString() const { return mErrorMessageFirstString; }

	void StartMessageQueue();
	void FlashMessageQueue();

protected:
	
	iOutputWindow(iShell *s);
	virtual ~iOutputWindow();

	const char* FormattedErrorMessage(const char* message);
	const char* FormattedWarningMessage(const char* message);

	int mErrorMessageFirstSymbol;
	char *mErrorMessageFirstString;

	//
	//  Thread-safe workaround
	//
	vtkCriticalSection *mMutex;
	int mQueue;
	iArray<iString> mTextQueue;
	iArray<iString> mErrorQueue;
};

#endif  // IOUTPUTWINDOW_H
