/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ICOLORBARS_H
#define ICOLORBARS_H


#include <vtkActor2D.h>
#include "iobject.h"
#include "ioverlaybase.h"
#include "iviewmodulecomponent.h"


#include "iarray.h"
#include "iparameter.h"

class iColorBarsLabel;
class iDataType;
class iPalette;
class iTextActor;

class vtkRenderer;
class vtkScalarBarActor;


class iColorBars: public vtkActor2D, public iObject, protected iOverlayBase, protected iViewModuleComponent
{
	
public:
	
	IOBJECT_DECLARE_SELF(iColorBars,iObject);

	static iColorBars* New(iViewModule *vm);
	static const iObjectType& Type();
	
	IOBJECT_DECLARE_GETSET1(Color,iColor);
	//virtual void SetColor(iColor c);
	//inline iColor GetColor() const { return mColor; }

	IOBJECT_DECLARE_GETSET(SideOffset,mXOff[1],float);
	//virtual void SetSideOffset(float v);
	//inline float GetSideOffset() const { return mXOff[1]; }

	IOBJECT_DECLARE_GETSET1(Automatic,bool);
	//virtual void SetAutomatic(bool);
	//inline bool GetAutomatic() const { return mAutomatic; }

	virtual void SetBar(int bar, int v, int id, int p); 
	virtual void GetBar(int bar, int &v, int &id, int &p) const; 
	static const iObjectKey& KeyBarLeft();
	static const iObjectKey& KeyBarRight();

	virtual void SetFontScale(int s);

	virtual void SetFontType(int t);
	inline int GetFontType() const { return mFontType; }

	virtual int RenderOverlay(vtkViewport*);
	virtual int RenderOpaqueGeometry(vtkViewport*);
	virtual int RenderTranslucentGeometry(vtkViewport *){ return 0; }
	
	virtual void ReleaseGraphicsResources(vtkWindow *win);

	virtual void ShowBar(int priority, int v, const iDataType &dt, int p, bool s);

protected:
	
	iColorBars(iViewModule *vm);
	virtual ~iColorBars();
	
	virtual void PackStateBody(iString &s) const;
	virtual void UnPackStateBody(const iString &s);

private:

	struct QueueItem
	{
		int Var;
		int Palette;
		int DataTypeId;
		int Priority;
		int Count;
		bool operator<(const QueueItem &item) const;
		bool operator==(const QueueItem &item) const;
	};

	iOrderedArray<QueueItem>& Queue();

	int mFontType;

	bool mStarted, mAutomatic;
	float mScale;

	float mHeight, mWidth;
	float mXOff[2], mYOff;
	float mTextOff[2], mTitleOff[2];
	int mJmax;

	iColor mColor;

	iOrderedArray<QueueItem> mAutomaticBars;
	iOrderedArray<QueueItem> mManualBars;

	static const QueueItem NullQueueItem;

	vtkScalarBarActor *mBarActor[2];
	iTextActor *mTitleActor[2];
	iArray<iColorBarsLabel*> mLabels;
};


inline iOrderedArray<iColorBars::QueueItem>& iColorBars::Queue()
{
	return mAutomatic ? mAutomaticBars : mManualBars;
}

#endif // ICOLORBARS_H
