/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Tuning parameters and optimized basic operations 
//

#ifndef ITUNE_H
#define ITUNE_H


#define ITUNEDEFS_H
#include "itunedefs.h"
#undef ITUNEDEFS_H


class iTune
{
	
public:
	
	static void Tune();

	static void CopyCharPointers(char *dest, const char *src, int len);
	static void MoveCharPointers(char *dest, const char *src, int len);

	static void CopyIntPointers(int *dest, const int *src, int len);
	static void CopyFloatPointers(float *dest, const float *src, int len);
	static void CopyDoublePointers(double *dest, const double *src, int len);
};


#if ITUNE_INLINE == 1

#define ITUNEWORK_H
#include "itunework.h"
#undef ITUNEWORK_H

#undef ITUNE_DONE
#undef ITUNE_INLINE
#undef ITUNE_CCP
#undef ITUNE_MCP
#undef ITUNE_CIP
#undef ITUNE_CFP
#undef ITUNE_CDP

#endif // ITUNE_INLINE

#endif // ITUNE_H

