/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggextensionwindow.h"


#include "ierror.h"
//#include "iimagefactory.h"

#include "iggabstractextension.h"
#include "iggmainwindow.h"

#include "ibgextensionwindowsubject.h"
#include "ibgframesubject.h"

#include "iggextensionfactory.h"
#include "iggsubjectfactory.h"
#include "iggparameter.h"
using namespace iggParameter;
//using namespace iParameter;

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"


//
//  Main class
//
iggExtensionWindow::iggExtensionWindow(iggMainWindow *mw) : iShellComponent(mw?mw->GetShell():0), mExt(0)
{
	mCurExt = 0;
	mMainWindow = mw; IERROR_ASSERT_NULL_POINTER(mw);

	//
	//  Query iggExtensionFactory for all extensions
	//
	unsigned int key = 1;
	iggAbstractExtension *ext;
	do
	{
		ext = iggExtensionFactory::CreateExtension(mMainWindow,key);
		if(ext != 0) mExt.Add(ext);
		key = key << 1;
	}
	while(key != 0); // shift 1 through all possible positions

	//
	//  Create subject
	//
	mSubject = iggSubjectFactory::CreateExtensionWindowSubject(this,mExt.Size()<2);

	//
	//  Attach extensions
	//
	int i;
	for(i=0; i<mExt.Size(); i++)
	{
		mSubject->AddExtension(mExt[i]);
		mExt[i]->SetPadding(false);
		mExt[i]->CompleteInitialization();
	}
}

	
iggExtensionWindow::~iggExtensionWindow()
{
	while(mExt.Size() > 0) delete mExt.RemoveLast();
	mSubject->Delete();
}


void iggExtensionWindow::AttachSubject(ibgExtensionWindowSubject *subject)
{
	mSubject = subject; IERROR_ASSERT_NULL_POINTER(subject);
}


//
//  Special functions
//
void iggExtensionWindow::UpdateAll()
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->UpdateWidget();
}


bool iggExtensionWindow::IsEmpty() const
{
	return mExt.Size() == 0;
}


//
//  Decorator methods
//
void iggExtensionWindow::LogDataInfo(const iDataType &type, bool details)
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->LogDataInfo(type,details);
}


void iggExtensionWindow::OpenBookPageByIndex(int index)
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->OpenBookPageByIndex(index);
}


void iggExtensionWindow::SetTabMode(int m)
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->SetTabMode(m);
}


void iggExtensionWindow::PopulateFileMenu()
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->PopulateFileMenu();
}


void iggExtensionWindow::PopulateLocalDialogMenu()
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->PopulateLocalDialogMenu();
}


void iggExtensionWindow::PopulateGlobalDialogMenu()
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->PopulateGlobalDialogMenu();
}


void iggExtensionWindow::PopulateFileToolBar()
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->PopulateFileToolBar();
}


void iggExtensionWindow::PopulateShowToolBar()
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->PopulateShowToolBar();
}


bool iggExtensionWindow::OnMenuBody(int id, bool on)
{
	int i;
	for(i=0; i<mExt.Size(); i++) if(mExt[i]->OnMenuBody(id,on)) return true;
	return false;
}


void iggExtensionWindow::UpdateOnPick()
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->UpdateOnPick();
}


void iggExtensionWindow::UpdateParticleSetWidgets(const iImage *icon)
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->UpdateParticleSetWidgets(icon);
}


void iggExtensionWindow::AddReloadingDataTypes(iggPageData *page)
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->AddReloadingDataTypes(page);
}


void iggExtensionWindow::AddParticleSetIcons()
{
	int i;
	for(i=0; i<mExt.Size(); i++) mExt[i]->AddParticleSetIcons();
}

