/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IDATADISTRIBUTOR_H
#define IDATADISTRIBUTOR_H


#include "ideletable.h"


template<class T> class iArray;
class iViewObject;

class vtkImageData;
class vtkPolyData;
class vtkStructuredPoints;


template<class InputType>
class iDataDistributor : public iDeletable
{

public:

	virtual void DistributeData(InputType *input, iArray<InputType*> &parallelInputs) = 0;
	//
	//  Serves both types of output
	//
	virtual void PolishOutput(iViewObject *, vtkStructuredPoints *) = 0;
	virtual void PolishOutput(iViewObject *, vtkPolyData *) = 0;

protected:

	iDataDistributor(){}
	virtual ~iDataDistributor(){}
};

//
//  Specific data distributors
//
class iGridDataDistributor : public iDataDistributor<vtkImageData>
{

public:

	iGridDataDistributor();
	virtual ~iGridDataDistributor();

	inline int GetSplitDimension() const { return mDim; }

	virtual void DistributeData(vtkImageData *input, iArray<vtkImageData*> &parallelInputs);
	//
	//  Serves both types of output
	//
	virtual void PolishOutput(iViewObject *, vtkStructuredPoints *);
	virtual void PolishOutput(iViewObject *, vtkPolyData *);

protected:

	int mNumEdges, mDim;
	double *mEdges;
};


class iPolyDataDistributor : public iDataDistributor<vtkPolyData>
{

public:

	iPolyDataDistributor();
	virtual ~iPolyDataDistributor();

	virtual void DistributeData(vtkPolyData *input, iArray<vtkPolyData*> &parallelInputs);
	//
	//  Serves both types of output
	//
	virtual void PolishOutput(iViewObject *, vtkStructuredPoints *);
	virtual void PolishOutput(iViewObject *, vtkPolyData *);
};

#endif  // IDATADISTRIBUTOR_H
