/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Header file for iCrossSectionViewObject class
//

#ifndef ICROSSSECTIONVIEWOBJECT_H
#define ICROSSSECTIONVIEWOBJECT_H


#include "isolidviewobject.h"


class iCrossSectionParallelPipeline;
class iCrossSectionSerialPipeline;

class vtkTexture;


class iCrossSectionViewObject : public iSolidViewObject 
{
	
	friend class iExtensionFactory;

public:
	
	static iCrossSectionViewObject* New(iViewModule *vm);
	virtual ~iCrossSectionViewObject();
	static const iObjectType& Type();
		
	IOBJECT_DECLARE_GETSET1(Dir,int);
//	virtual void SetDir(int d);
//	inline int GetDir() const { return mDir; }

	IOBJECT_DECLARE_GETSET(Var,mVar[mActiveDataTypeIndex],int);
//	virtual void SetVar(int v);
//	inline int GetVar() const { return mVar[mActiveDataTypeIndex]; }

	IOBJECT_DECLARE_GET1(OverTheEdgeFlag,bool);
//	inline int GetOverTheEdgeFlag() const { return mOverTheEdgeFlag; }

	IOBJECT_DECLARE_GETSET1(ResampleFactor,int);
//	virtual void SetResampleFactor(int p);
//	inline int GetResampleFactor() const { return mResampleFactor };

	IOBJECT_DECLARE_GETSET1(Method,int);
//	virtual void SetMethod(int m);
//	inline int GetMethod() const { return mMethod; }

	IOBJECT_DECLARE_GETSET1(InterpolateData,bool);
//	virtual void SetInterpolateData(bool s);
//	inline bool GetInterpolateData(){ return mInterpolateData; }

	virtual bool SetPos(double p, bool checkPosMax = true);
	virtual bool SetPos(const iDistance &p, bool checkPosMax = true);
	inline const iDistance& GetPos() { return mPos; }
	static const iObjectKey& KeyPos(bool opengl = false);

	//
	//  Action key
	//
	virtual void PlaceAtSpecialLocation(int n);
	static const iObjectKey& KeySpecialLocation();

//	inline vtkLookupTable* GetColorLookupTable() const { return mColorLookupTable; }
	
	void ForcePolygonalMethod(bool s);

	inline int GetActualMethod() const { if(mForcePolygonalMethod) return 0; else return mMethod; }

	virtual iCrossSectionParallelPipeline* CreateParallelPipeline();
	virtual iCrossSectionSerialPipeline* CreateSerialPipeline();

	//
	//  Inherited members
	//
	ISOLIDVIEWOBJECT_DECLARE_INHERITED_KEYS;
	ISOLIDVIEWOBJECT_DECLARE_INHERITED_MEMBERS;

protected:
	
	iCrossSectionViewObject(iViewModule *vm, const iDataInfo &info);

	void UpdateScalarRange();

	bool mInterpolateData, mOverTheEdgeFlag;

	iDistance mPos, mPosMax;
	iArray<int> mVar;
	int mDir;
	int mMethod, mResampleFactor;
	bool mForcePolygonalMethod;
	//
	//  VTK stuff
	//
	vtkTexture *mTexture;
	iCrossSectionParallelPipeline *mPipeline;
};

#endif // ICROSSSECTIONVIEWOBJECT_H

