/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  These are the main work-horse functions. They should be either inlined or 
//  compiled separately with the highest optimization options and then used
//  with Inter-Procedural Analysis tool.
//  This file should only be include within "itune.h" or "itune.cpp" files.
//

#ifdef ITUNEWORK_H

#include <string.h>

#ifdef ITUNE_INLINE 
inline void iTune::CopyCharPointers(char *dest, const char *src, int len)
#else
void iTune::CopyCharPointers(char *dest, const char *src, int len)
#endif
{
	//
	//  This version only produces the correct result if copied regions are 
	//  not overlapping, like memcpy
	//
	if(len > ITUNE_CCP) memcpy(dest,src,len); else  
	{
		for(int i=0; i<len; i++) dest[i] = src[i];  // this is better for pipelining
	}
}


#ifdef ITUNE_INLINE 
inline void iTune::MoveCharPointers(char *dest, const char *src, int len)
#else
void iTune::MoveCharPointers(char *dest, const char *src, int len)
#endif
{
	//
	//  This version produces the correct result even if copied regions are 
	//  overlapping, like memmove, but it is slower than CopyCharPointers
	//
	if(len > ITUNE_MCP) memmove(dest,src,len); else  
	{
		if(dest < src)
		{
			for(int i=0; i<len; i++) dest[i] = src[i];  // this is better for pipelining
		}
		else
		{
			for(int i=len-1; i>=0; i--) dest[i] = src[i];  // this is better for pipelining?
		}
	}
}


#ifdef ITUNE_INLINE 
inline void iTune::CopyFloatPointers(float *dest, const float *src, int len)
#else
void iTune::CopyFloatPointers(float *dest, const float *src, int len)
#endif
{
	//
	//  This version only produces the correct result if copied regions are 
	//  not overlapping, like memcpy
	//
	if(len > ITUNE_CFP) memcpy(dest,src,sizeof(float)*len); else  
	{
		for(int i=0; i<len; i++) dest[i] = src[i];  // this is better for pipelining
	}
}


#ifdef ITUNE_INLINE 
inline void iTune::CopyIntPointers(int *dest, const int *src, int len)
#else
void iTune::CopyIntPointers(int *dest, const int *src, int len)
#endif
{
	//
	//  This version only produces the correct result if copied regions are 
	//  not overlapping, like memcpy
	//
	if(len > ITUNE_CIP) memcpy(dest,src,sizeof(int)*len); else  
	{
		for(int i=0; i<len; i++) dest[i] = src[i];  // this is better for pipelining
	}
}


#ifdef ITUNE_INLINE 
inline void iTune::CopyDoublePointers(double *dest, const double *src, int len)
#else
void iTune::CopyDoublePointers(double *dest, const double *src, int len)
#endif
{
	//
	//  This version only produces the correct result if copied regions are 
	//  not overlapping, like memcpy
	//
	if(len > ITUNE_CDP) memcpy(dest,src,sizeof(double)*len); else  
	{
		for(int i=0; i<len; i++) dest[i] = src[i];  // this is better for pipelining
	}
}

#endif

