/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
  
//
//  This class is based on original vtkQGLRenderWindow class written by Manish P. Pagey [pagey@drcsdca.com ]
//


#ifndef IRENDERWINDOW_H
#define IRENDERWINDOW_H

#include <stdlib.h>
#include <qgl.h>

#include <vtkOpenGLRenderWindow.h>


// ------------------------------------------------------------
// :TRICKY: Fri Apr 21 22:19:27 2000 Pagey
// The Signal/Slot mechanism used by Qt requires that QGLWidget 
// appear as the first class when using multiple inheritance. 
// Hence the order of the two classes QGLWidget and vtkRenderWindow
// matters here. Be careful not to change it by accident. 
// ------------------------------------------------------------
class iRenderWindow : public QGLWidget, public vtkOpenGLRenderWindow
{

	Q_OBJECT 

public:

	// ------------------------------------------------------------
	// Methods from vtkRenderWindow class. 
	//
	static iRenderWindow *New(QWidget *parent=0, const char *name=0) {
		return new iRenderWindow(parent,name);
	}
	const char *GetClassName() { return "iRenderWindow"; }
	
	virtual void Start(void);
	void Frame(void);
	virtual void WindowInitialize(void);
	virtual void SetFullScreen(int);
	virtual void WindowRemap(void);
	virtual void PrefFullScreen(void);
	virtual void SetSize(int,int);
	
	// Description:
	// Make this window the current OpenGL context.
	void MakeCurrent();
	
	//
	//  These method appeared in VTK 4.4. I have no idea what they do
	//
	void SetNextWindowId(void *){}
	void SetNextWindowInfo(char *){}

	//
	//  The whole thing below is very stupid - VTK does not define 
	//  vtkOpenGLRenderWindow::MakeCurrent() as virtual, so we cannot 
	//  inherit from vtkOpenGLRenderWindow and overwrite it - we need
	//  to copy parts of vtkOpenGLRenderWindow
	//

	virtual void *GetGenericContext();
	virtual void *GetGenericDisplayId();
	virtual void *GetGenericWindowId() { return (void *)this->winId(); }
    // Description:
    // Dummy stubs for vtkWindow API.
	virtual void SetDisplayId(void *) {}
	void SetWindowId(void *) {}
	void SetParentId(void *) {}
	virtual void *GetGenericParentId() { return NULL; }
	virtual void *GetGenericDrawable() { return NULL; }
	void SetWindowInfo(char *) {}
	void SetParentInfo(char *) {}
	void HideCursor() {}
	void ShowCursor() {}
	virtual int GetEventPending() { return 0; }
	// ------------------------------------------------------------
	// Methods from QGLWidget class. 
	//
	virtual void setContext( QGLContext *context, 
		const QGLContext *shareContext=0, 
		bool deleteOldContex=true );

protected:

	bool mInitialized ;
	iRenderWindow(QWidget *parent, const char *name);
	~iRenderWindow() ;
	
	// ------------------------------------------------------------
	// Methods from QGLWidget class. 
	//
	virtual void initializeGL();
	virtual void paintGL();
	virtual void resizeGL(int w, int h);
	virtual void mouseMoveEvent(QMouseEvent *);
	virtual void mousePressEvent(QMouseEvent *);
	virtual void mouseReleaseEvent(QMouseEvent *);
	virtual void keyPressEvent(QKeyEvent *);

	//
	//  Display Id & Context
	//
	void *GenericDisplayId;
	void *GenericContext;

	bool inRender;

	//
	// Every focus-in and focus-out event results in a repaint 
	// through the default implementations of focusInEvent and
	// focusOutEvent. This results in a flicker in the vtkQGLRenderWindow
	// ever time the cursor moves in or out of the widget. We can 
	// disble this by calling repaint(false) in the implementation
	// of these methods. 
	//
	virtual void focusInEvent( QFocusEvent * ) { repaint(false); }
	virtual void focusOutEvent( QFocusEvent * ) { repaint(false); }
	//
	// If this widget is not the top level widget, it does not 
	// get focus until it receives its first mouse click. By 
	// overloading the enterEvent and leaveEvent methods, we 
	// give keyboard focus to the widget when the mouse enters
	// and remove the focus once the mouse leaves. 
	//
//	virtual void enterEvent( QEvent * ) { setFocus(); }
//	virtual void leaveEvent( QEvent * ) { clearFocus(); }
	
	/* ------------------------------------------------------------
	* A few signals which will help us write an interactor for this
	* render window. 
	*/
signals:
	//
	// Mouse moved. 
	//
	void MouseMove(const QMouseEvent *event);
	//
	// Left button pressed/released at the specified location.
	//
	void LeftButtonPressed(const QMouseEvent *event);
	void LeftButtonReleased(const QMouseEvent *event);
	//
	// Middle button pressed/released at the specified location.
	//
	void MiddleButtonPressed(const QMouseEvent *event);
	void MiddleButtonReleased(const QMouseEvent *event);
	//
	// Right button pressed/released at the specified location.
	//
	void RightButtonPressed(const QMouseEvent *event);
	void RightButtonReleased(const QMouseEvent *event);
	//
	// Any mouse button pressed.
	//
	void ButtonPressed(const QMouseEvent *event);
	void ButtonReleased(const QMouseEvent *event);
	//
	// Any key pressed.
	//
	void KeyPressed(QKeyEvent *event);

private:

	iRenderWindow(const iRenderWindow&) ; // never implemented
	void operator=(const iRenderWindow&) ; // never implemented 

};

#endif //IRENDERWINDOW_H
