/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "ikeyboardinteractor.h"

#include "ivtk.h"
#include "ivtkwindow.h"
#include "iqt.h"
#include "iqtwindow.h"


#include <qapplication.h>
#include <qevent.h>
#include <qpixmap.h>
#include <qsizepolicy.h>
#include <qtooltip.h>


#include <vtkRenderer.h>
#include <vtkCamera.h>


QPixmap image(char *s);



iKeyboardInteractor::iKeyboardInteractor(QWidget *parent, const char *name, WFlags f) : QLabel(parent,name,f) 
{
	imgOn = image("keyboard.png").convertToImage();
	imgOff = image("keyboardoff.png").convertToImage();
	imgWork = image("keyboardoff.png").convertToImage();
	this->setFrameShadow(QFrame::Sunken);
	this->setFrameShape(QFrame::WinPanel);
	this->setScaledContents(true);
	this->setMargin(1);
	this->setPixmap(QPixmap(imgOff.smoothScale(this->width()-6,this->height()-6)));
	this->setFocusPolicy(QWidget::StrongFocus);
	//
	//  Initialize extension
	//
	this->extension(0);
}

void iKeyboardInteractor::setToolTip(QString &s)
{
	QToolTip::add(this,"<ul><li><b>arrow keys</b>: rotate the scene.<li><b>+/-</b>: zoom in/out.<li><b>[Ctrl]</b>: increase the step.<li><b>[Alt]</b>: decrease the step."+s+"</ul>");
}


void iKeyboardInteractor::enterEvent(QEvent *vtkNotUsed(e))
{
	if((QWidget *)iQTWindow::getCurrentWindow() == qApp->activeWindow())
	{
		this->setPixmap(QPixmap(imgOn.smoothScale(this->width()-6,this->height()-6)));
		this->setFrameShadow(QFrame::Raised);
		this->setFocus();
	} 
	else this->leaveEvent(0);
}

	
void iKeyboardInteractor::leaveEvent(QEvent *vtkNotUsed(e))
{
	this->setPixmap(QPixmap(imgOff.smoothScale(this->width()-6,this->height()-6)));
	this->setFrameShadow(QFrame::Sunken);
	this->clearFocus();
}


void iKeyboardInteractor::keyPressEvent(QKeyEvent *e)
{
	int i, n = 0;

	if(this->extension(e)) return;

	bool ctr = e->state() & Qt::ControlButton;
	bool sht = e->state() & Qt::ShiftButton;
	bool alt = e->state() & Qt::AltButton;

	switch (e->key())
	{
	case Qt::Key_F1:
	case Qt::Key_Help:
		{
			if(e->state()!=0 || !this->hasMouse()) e->ignore(); else
			{
				iQTWindow::getCurrentWindow()->showHelp("vtkkeybd.ihf"); 
				e->accept();
			}
			break;
		} 
	case Qt::Key_Left: n = -1;
	case Qt::Key_Right:
		{
			if(n == 0) n = 1;
			if(!sht)
			{
				float q = 1.0;
				if(ctr) q = 5.0;
				if(alt) q = 0.1;
				if(iVTKWindow::getCurrentWindow()->isBroadcastMouseEventsOn())
				{
					for(i=0; i<=iVTKWindow::getMaxWindowIndex(); i++) 
					{
						iVTKWindow::getWindow(i)->getRenderer()->GetActiveCamera()->Azimuth(-q*n);
						iVTKWindow::getWindow(i)->render(false);
					}
				}
				else
				{
					iVTKWindow::getCurrentWindow()->getRenderer()->GetActiveCamera()->Azimuth(-q*n);
					iVTKWindow::getCurrentWindow()->render(false);
				}
			}
			e->accept();
			break;
		}
	case Qt::Key_Down: n = -1;
	case Qt::Key_Up:
		{
			if(n == 0) n = 1;
			if(!sht)
			{
				float q = 1.0;
				if(ctr) q = 5.0;
				if(alt) q = 0.1;
				if(iVTKWindow::getCurrentWindow()->isBroadcastMouseEventsOn())
				{
					for(i=0; i<=iVTKWindow::getMaxWindowIndex(); i++) 
					{
						iVTKWindow::getWindow(i)->getRenderer()->GetActiveCamera()->Elevation(-q*n);
						iVTKWindow::getWindow(i)->getRenderer()->GetActiveCamera()->OrthogonalizeViewUp();
						iVTKWindow::getWindow(i)->render(false);
					}
				}
				else
				{
					iVTKWindow::getCurrentWindow()->getRenderer()->GetActiveCamera()->Elevation(-q*n);
					iVTKWindow::getCurrentWindow()->getRenderer()->GetActiveCamera()->OrthogonalizeViewUp();
					iVTKWindow::getCurrentWindow()->render(false);
				}
			}
			e->accept();
			break;
		}
	case Qt::Key_Minus: n = -1;
	case Qt::Key_Plus:
		{
			if(n == 0) n = 1;
			float q = 1.0;
			if(ctr) q = 5.0;
			if(alt) q = 0.1;
			if(iVTKWindow::getCurrentWindow()->isBroadcastMouseEventsOn())
			{
				for(i=0; i<=iVTKWindow::getMaxWindowIndex(); i++) 
				{
					iVTKWindow::getWindow(i)->getRenderer()->GetActiveCamera()->Zoom(pow(10.0,0.01*q*n));
					iVTKWindow::getWindow(i)->render(false);
				}
			}
			else
			{
				iVTKWindow::getCurrentWindow()->getRenderer()->GetActiveCamera()->Zoom(pow(10.0,0.01*q*n));
				iVTKWindow::getCurrentWindow()->render(false);
			}
			e->accept();
			break;
		}
	default: { e->ignore(); }
	}
}


#if !EDITION

bool iKeyboardInteractor::extension(QKeyEvent *e)
{
	return false;
}

#endif


