/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include <qpixmap.h>
#include <qapplication.h>
#include <qwidgetstack.h>

#include "imath.h"
#include "ivtk.h"


QPixmap image(char *);


void iDialogProgress::init()
{

    cancelled = false;
    currentFrame = -2;
    
    BottomStack = new QWidgetStack(this);
    LayoutBottom->insertWidget(1,BottomStack);
    
    CancelButton = new QPushButton(this);
    CancelLabel = new QLabel(this);
    
    BottomStack->addWidget(CancelButton);
    BottomStack->addWidget(CancelLabel);
    
    CancelButton->setText("Interrupt");
    connect(CancelButton, SIGNAL( clicked() ) , this, SLOT( cancel() ) );
    
    CancelLabel->setText("Interrupting all processes...");
    CancelLabel->setAlignment(Qt::AlignHCenter);

	frames = new QPixmap[15];

    QString s;
    for(int i=0; i<15; i++)
	{
		s = QString("genie1_frame_0") + s.sprintf("%02d",i) + ".png";
		frames[i] = image((char *)s.latin1());
	}

}


void iDialogProgress::destroy()
{
	delete [] frames;
}

void iDialogProgress::start()
{
    time.start();
    timePrev = 0;
    cancelled = false;
    PixmapLabel->setPaletteBackgroundPixmap(frames[0]);
    currentFrame = -1;
    BottomStack->raiseWidget(CancelButton);
}


void iDialogProgress::keepWorking()
{
    static QString s;
    
	if(cancelled || currentFrame==-2) return;

	if((currentFrame==-1 && time.elapsed()>timePrev+2000) || (currentFrame>=0 && time.elapsed()>timePrev+200))
    {
		if(currentFrame == -1) 
		{
			currentFrame = 0;
			iVTK::blockEvents(true);
			this->show();
		}	
		currentFrame++;
		if(currentFrame == 15) currentFrame = 0;
		PixmapLabel->setPaletteBackgroundPixmap(frames[currentFrame]);
		ElapsedTimeLCD->display(0.1*round(time.elapsed()*0.01));
		timePrev = time.elapsed();
	    qApp->processEvents();
    }
    
}


void iDialogProgress::cancel()
{
    cancelled = true;
    currentFrame = -2;
    BottomStack->raiseWidget(CancelLabel);
}


bool iDialogProgress::isCancelled()
{
    return cancelled;
}


void iDialogProgress::finish()
{
    cancelled = false;
    this->hide();
	iVTK::blockEvents(false);
    currentFrame = -2;
    qApp->restoreOverrideCursor();  // just in case
}





