/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/


#include <vtkVersion.h>
#include <qapplication.h>

#include <qstring.h>
#include <qimage.h>
#include <qdatetime.h>

#include "imath.h"
#include "iglobals.h"
#include "iversion.h"

#include "ivtk.h"
#include "iqt.h"
#include "iqtwindow.h"


QPixmap image(char *s);
void iSleep(int);

void iDialogAbout::close()
{
	
    QPixmap p;
    QString s;
    for(int i=0; i<15; i++){
	s = QString("genie1_frame_0") + s.sprintf("%02d",i) + ".png";
	TextLabel1->setPaletteBackgroundPixmap(image((char *)s.latin1()));
	TextLabel1->repaint();
	iSleep(100); 
    }
    this->accept();

}


void iDialogAbout::init()
{

    TextLabel_Date->setText(QString(iVersion::getBuild()));
    TextLabel_Version->setText(QString(iVersion::getVersion()));
	TextLabel_VTK->setText(QString("VTK")+" "+VTK_VERSION);
	TextLabel_Qt->setText(QString("Qt")+" "+qVersion());
    TextLabel_Edition->setText(iVersion::getEditionName());
    
}


