/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "iglobals.h"
#include "icubeaxesactor.h"
#include "ivtk.h"

#include <vtkRenderer.h>
#include <vtkAxisActor2D.h>
#include <vtkViewport.h>
#include <vtkProperty2D.h>
#ifndef I_VTK_VERSION_40
#include <vtkTextProperty.h>
#endif

	
iCubeAxesActor* iCubeAxesActor::New()
{
	return new iCubeAxesActor;
}


iCubeAxesActor::iCubeAxesActor()
{
	fontSize = 16;
	FontFactor = 1.2;

#ifndef I_VTK_VERSION_40
	this->AxisLabelTextProperty->BoldOn();
	this->AxisLabelTextProperty->ItalicOff();
	this->AxisLabelTextProperty->ShadowOn();
	this->AxisLabelTextProperty->SetFontFamilyToArial();
	this->AxisTitleTextProperty->BoldOn();
	this->AxisTitleTextProperty->ItalicOff();
	this->AxisTitleTextProperty->ShadowOn();
	this->AxisTitleTextProperty->SetFontFamilyToArial();
	this->XAxis->SetLabelTextProperty(AxisLabelTextProperty);
	this->YAxis->SetLabelTextProperty(AxisLabelTextProperty);
	this->ZAxis->SetLabelTextProperty(AxisLabelTextProperty);
	this->XAxis->SetTitleTextProperty(AxisTitleTextProperty);
	this->YAxis->SetTitleTextProperty(AxisTitleTextProperty);
	this->ZAxis->SetTitleTextProperty(AxisTitleTextProperty);
#else
	this->BoldOn();
	this->ItalicOff();
	this->ShadowOn();
#endif
	this->SetFlyModeToOuterEdges();
	this->SetLabelFormat("%6.2g");
	this->ScalingOff();
	float b = 1.0;
	this->SetBounds(-b,b,-b,b,-b,b);
	this->SetNumberOfLabels(4);
	this->UseRangesOn();
	this->GetProperty()->SetColor(0.0,0.0,0.0);
}


int iCubeAxesActor::RenderOverlay(vtkViewport *viewport)
{
	return vtkCubeAxesActor2D::RenderOverlay(viewport);
}


int iCubeAxesActor::RenderOpaqueGeometry(vtkViewport *viewport)
{
	//
	//  First of all do nothing if no axes are visible
	//
	if(this->XAxisVisibility==0 && this->YAxisVisibility==0 && this->ZAxisVisibility==0)
	{
		return 0;
	}

	iVTK *vtk = iVTK::convertFromViewport(viewport);

	int renderedSomething = 0;
	int mag = vtk->getRenderingMagnification();
	if(mag == 1)
	{
		//
		//  Scale fonts
		//
//#ifndef I_VTK_VERSION_40  //  not clear why this is not working
//		this->AxisTitleTextProperty->SetFontSize(fontSize);
//		this->AxisLabelTextProperty->SetFontSize(fontSize);
//#else
		this->XAxis->SetFontFactor(this->FontFactor*fontSize/16);
		this->YAxis->SetFontFactor(this->FontFactor*fontSize/16);
		this->ZAxis->SetFontFactor(this->FontFactor*fontSize/16);
//#endif
		//
		//  Render and save axes positions
		//
		renderedSomething = vtkCubeAxesActor2D::RenderOpaqueGeometry(viewport);
		
		this->XAxis->GetPositionCoordinate()->GetValue(pos1X);
		this->YAxis->GetPositionCoordinate()->GetValue(pos1Y);
		this->ZAxis->GetPositionCoordinate()->GetValue(pos1Z);

		this->XAxis->GetPosition2Coordinate()->GetValue(pos2X);
		this->YAxis->GetPosition2Coordinate()->GetValue(pos2Y);
		this->ZAxis->GetPosition2Coordinate()->GetValue(pos2Z);
	}
	else
	{
		//
		//  Scale fonts
		//
//#ifndef I_VTK_VERSION_40  //  not clear why this is not working
//		this->AxisTitleTextProperty->SetFontSize(mag*fontSize);
//		this->AxisLabelTextProperty->SetFontSize(mag*fontSize);
//#else
		this->XAxis->SetFontFactor(mag*this->FontFactor*fontSize/16);
		this->YAxis->SetFontFactor(mag*this->FontFactor*fontSize/16);
		this->ZAxis->SetFontFactor(mag*this->FontFactor*fontSize/16);
//#endif
		//
		//  compute shifts
		//
		int winij[2];
		vtk->computePositionShiftsUnderMagnification(winij,viewport);
		//
		//  shift positions: positions are in viewport coordinates, so need to scale
		//  winij appropriately
		//
		int *s = viewport->GetSize();
		winij[0] *= s[0];
		winij[1] *= s[1];

		this->XAxis->GetPositionCoordinate()->SetValue(mag*pos1X[0]-winij[0],mag*pos1X[1]-winij[1]);
		this->YAxis->GetPositionCoordinate()->SetValue(mag*pos1Y[0]-winij[0],mag*pos1Y[1]-winij[1]);
		this->ZAxis->GetPositionCoordinate()->SetValue(mag*pos1Z[0]-winij[0],mag*pos1Z[1]-winij[1]);

		if(this->XAxis->GetPosition2Coordinate()->GetReferenceCoordinate() == 0) this->XAxis->GetPosition2Coordinate()->SetValue(mag*pos2X[0]-winij[0],mag*pos2X[1]-winij[1]); else this->XAxis->GetPosition2Coordinate()->SetValue(mag*pos2X[0],mag*pos2X[1]);
		if(this->YAxis->GetPosition2Coordinate()->GetReferenceCoordinate() == 0) this->YAxis->GetPosition2Coordinate()->SetValue(mag*pos2Y[0]-winij[0],mag*pos2Y[1]-winij[1]); else this->YAxis->GetPosition2Coordinate()->SetValue(mag*pos2Y[0],mag*pos2Y[1]);
		if(this->ZAxis->GetPosition2Coordinate()->GetReferenceCoordinate() == 0) this->ZAxis->GetPosition2Coordinate()->SetValue(mag*pos2Z[0]-winij[0],mag*pos2Z[1]-winij[1]); else this->ZAxis->GetPosition2Coordinate()->SetValue(mag*pos2Z[0],mag*pos2Z[1]);
		//	
		//Render the axes
		//
		if(this->XAxisVisibility)
		{
			renderedSomething += this->XAxis->RenderOpaqueGeometry(viewport);
		}
		if(this->YAxisVisibility)
		{
			renderedSomething += this->YAxis->RenderOpaqueGeometry(viewport);
		}
		if(this->ZAxisVisibility)
		{
			renderedSomething += this->ZAxis->RenderOpaqueGeometry(viewport);
		}
		
	}
	return renderedSomething;

}


void iCubeAxesActor::setFontSize(int s)
{ 
	if(s>0 && s<99) fontSize = s; 
}


