/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*
Implementation of ivisualobject.h
*/

#include "ivisualobject.h"
#include "ivisualobjectobserver.h"
#include "ivtk.h"
#include "idatareader.h"


iVisualObject::iVisualObject(iVTK *m) : iObject(m)
{
	
	dataChannel = myVTK->getReader()->getCurrentDataChannel();
	
	init = true;
	
	clipPlaneOn = false;

	shade = false;
	ambient = 0.3f;
	diffuse = 0.4f;
	specular = 0.2f;
	specularPower = 50.0;

	objectObserver = iVisualObjectObserver::New();

}


iVisualObject::~iVisualObject()
{
	objectObserver->Delete();
}


void iVisualObject::setDataChannel(int c)
{
	if(c>=0 && c<=myVTK->getReader()->getMaxDataChannel())
	{
		this->showColorBars(false);
		dataChannel = c;
		this->showColorBars(true);
		this->updateDataChannel();
	}
}


void iVisualObject::setDataStream(int c)
{
	this->showColorBars(false);
	dataStream = c;
	this->showColorBars(true);
	this->updateDataChannel();
}


iLimits* iVisualObject::getLimits()
{
	return myVTK->getReader()->getLimits(this->dataChannel,this->dataStream);
}


void iVisualObject::packState(iString &s)
{
	s = "";
	this->packValue(s,"iVisualObject::dataChannel",dataChannel);
	this->packValue(s,"iVisualObject::clipPlaneOn",clipPlaneOn);
	this->packValue(s,"iVisualObject::shade",shade);
	this->packValue(s,"iVisualObject::ambient",ambient);
	this->packValue(s,"iVisualObject::diffuse",diffuse);
	this->packValue(s,"iVisualObject::specular",specular);
	this->packValue(s,"iVisualObject::specularPower",specularPower);
}


void iVisualObject::unpackState(iString s)
{
	int i; bool b; float f;

	if(this->unpackValue(s,"iVisualObject::dataChannel",i)) this->setDataChannel(i);
	if(this->unpackValue(s,"iVisualObject::clipPlaneOn",b)) this->showClipPlane(b);
	if(this->unpackValue(s,"iVisualObject::shade",b)) this->setShade(b);
	if(this->unpackValue(s,"iVisualObject::ambient",f)) this->setAmbient(f);
	if(this->unpackValue(s,"iVisualObject::diffuse",f)) this->setDiffuse(f);
	if(this->unpackValue(s,"iVisualObject::specular",f)) this->setSpecular(f);
	if(this->unpackValue(s,"iVisualObject::specularPower",f)) this->setSpecularPower(f);
}

