/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/****************************************************************************

 Classes containing palettes
 
****************************************************************************/
#ifndef IPALETTE_H
#define IPALETTE_H

class vtkColorTransferFunction;
class vtkLookupTable;

class iString;
class iPiecewiseFunction;


#include "icolor.h"


#define MAXPALETTE	99


class iPalette 
{
	
	friend class iPaletteList;

public:
	
	iPalette();
	virtual ~iPalette();
	
	virtual iColor getColor(int n);
	inline vtkColorTransferFunction* getFunction(){ return cf; }
	inline vtkLookupTable* getTable(){ return lt; }
	inline void getPiecewiseFunctions(iPiecewiseFunction *&r, iPiecewiseFunction *&g, iPiecewiseFunction *&b){ r = funR; g = funG; b = funB; } 
	inline iPiecewiseFunction* getPiecewiseFunctionRed(){ return funR; } 
	inline iPiecewiseFunction* getPiecewiseFunctionGreen(){ return funG; } 
	inline iPiecewiseFunction* getPiecewiseFunctionBlue(){ return funB; } 

	virtual void setPiecewiseFunctions(iPiecewiseFunction *r, iPiecewiseFunction *g, iPiecewiseFunction *b);

	virtual void fillLookupTable(vtkLookupTable *t);

	virtual void reverse();
	virtual void update();

	virtual void copy(iPalette *p);

private:
	
	float r0[256];
	float g0[256];
	float b0[256];

	iPiecewiseFunction *funR, *funG, *funB;
	vtkColorTransferFunction *cf;
	vtkLookupTable *lt;
};



class iPaletteList {
	
public:
	
	friend class iQT;

	static void construct();
	static void destruct();

	inline static iPaletteList* getInstance(){ return me; };

	virtual iPalette* getPalette(int n);
	virtual iString* getPaletteName(int n);
	virtual int getNumPalettes();

	virtual void setPaletteName(int n, iString s);
	virtual bool addEmptyPalette();
	virtual void removePalette(int n);

	virtual void copy(iPaletteList *pl);

protected:

	virtual void createDefault();

	iPaletteList();
	virtual ~iPaletteList();
	
private:
	
	static iPaletteList* me;

	void setPalette_Rainbow(int n);
	void setPalette_Temperature(int n);
	void setPalette_Greyscale(int n);
	void setPalette_Bluewhite(int n);
	void setPalette_Prizm(int n);
	void setPalette_Greenwhite(int n);
	void setPalette_Bluered(int n);
	void setPalette_Stern(int n);
	void setPalette_Haze(int n);
	void setPalette_Starlight(int n);
	void setPalette_3color(int n);
	void setPalette_4color(int n);
	
	int numpal;
	iPalette* list;
	iString* names;
	
};

#endif // IPALETTE_H
