/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*=========================================================================

  Ifrit data filter: takes PolyData as the input and creates mesh data from
  them using gaussian filtering.

=========================================================================*/

#ifndef IMESHFROMPARTICLESFILTER_H
#define IMESHFROMPARTICLESFILTER_H

#include <vtkShepardMethod.h>


#define IMESHFROMPARTICLESFILTER_METHOD_SHEPARD	0

#define IMESHFROMPARTICLESFILTER_KERNEL_TOPHAT	0
#define IMESHFROMPARTICLESFILTER_KERNEL_LINEAR	1
#define IMESHFROMPARTICLESFILTER_KERNEL_SHEPARD	2



class iMeshFromParticlesFilter: public vtkShepardMethod
{
public:

	vtkTypeMacro(iMeshFromParticlesFilter,vtkShepardMethod);
	
	// Description:
	// Construct object to extract all of the input data.
	static iMeshFromParticlesFilter *New();
	
	virtual void setMethod(int m){ method = m; this->Modified(); }
	virtual int getMethod(){ return method; }

	virtual void setKernel(int m){ kernel = m; this->Modified(); }
	virtual int getKernel(){ return kernel; }

	virtual float getMemorySize();
	//
	//  Remove VTK limitation of MaximumDistance of 1.0
	//
	vtkSetMacro(MaximumDistance,float);

protected:
	
	iMeshFromParticlesFilter();
	~iMeshFromParticlesFilter(){}
	
	void ExecuteData(vtkDataObject *output);
//	void ExecuteInformation();

	void ExecuteShepardMethod();

private:

	int method;
	int kernel;
	
};

#endif


