#=========================================================================
#
#  Program:   Ionization FRont Interactive Tool (IFRIT)
#  Language:  C++
#
#
#Copyright (c) 2002-2003 Nick Gnedin 
#All rights reserved.
#
#Redistribution and use in source and binary forms, with or without
#modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
# * Neither name of Nick Gnedin nor the names of any contributors may be used 
#   to endorse or promote products derived from this software without specific
#   prior written permission.
#
# * Modified source versions must be plainly marked as such, and must not be
#   misrepresented as being the original software.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
#AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
#ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
#DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
#SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
#CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#=========================================================================

SOURCES	+= ianimator.cpp ianimatorscript.cpp icamerapath.cpp icaption.cpp icaptioninteractorstyle.cpp icolorbars.cpp icubeaxesactor.cpp idatachannelsource.cpp idatagateway.cpp idatareader.cpp ieditor.cpp ienvironment.cpp iexpressionparser.cpp ifrit.cpp ifunctionparser.cpp iglobals.cpp ihistogrammaker.cpp iinteractoreventrecorder.cpp ikeyboardinteractor.cpp ilegend.cpp ilightkit.cpp ilimits.cpp imarker.cpp imeasuringbox.cpp imeasuringboxinteractorstyle.cpp imeshfromparticlesfilter.cpp iobject.cpp iobjectfactory.cpp iorthoplane.cpp iorthoslicer.cpp iorthotextureplane.cpp ipalette.cpp iparallelizator.cpp iparticles.cpp iparticlesconnector.cpp iparticlesdataconverter.cpp iparticlessplitter.cpp ipicker.cpp ipiecewisefunction.cpp ipolygonaldata.cpp ipolygonaldataextender.cpp ipostscriptwriter.cpp iprobefilter.cpp iprogressbar.cpp iqtwindow.cpp irenderwindow.cpp irenderwindowinteractor.cpp iruler.cpp iscaledlodactor.cpp iscript.cpp istreamline.cpp isurface.cpp isurfaceshifter.cpp itensor.cpp itensordataconverter.cpp itext.cpp itextactor.cpp itextbitmap.cpp itextvector.cpp itrackball.cpp iuniformmeshdata.cpp iuniformmeshdataconverter.cpp iuniformmeshdataextender.cpp ivariablesview.cpp ivector.cpp iversion.cpp ivisualobject.cpp ivisualobjectobserver.cpp ivolume.cpp ivolumedataconverter.cpp ivtk.cpp ivtkcallback.cpp ivtkwindow.cpp ixsection.cpp 

HEADERS	+= ianimator.h   ianimatorscript.h   icamerapath.h   icaption.h   icaptioninteractorstyle.h   icolorbars.h   icubeaxesactor.h   idatachannelsource.h   idatagateway.h   idatareader.h   ieditor.h   ienvironment.h   iexpressionparser.h   ifrit.h   ifunctionparser.h   iglobals.h   ihistogrammaker.h   iinteractoreventrecorder.h   ikeyboardinteractor.h   ilegend.h   ilightkit.h   ilimits.h   imarker.h   imeasuringbox.h   imeasuringboxinteractorstyle.h   imeshfromparticlesfilter.h   iobject.h   iobjectfactory.h   iorthoplane.h   iorthoslicer.h   iorthotextureplane.h   ipalette.h   iparallelizator.h   iparticles.h   iparticlesconnector.h   iparticlesdataconverter.h   iparticlessplitter.h   ipicker.h   ipiecewisefunction.h   ipolygonaldata.h   ipolygonaldataextender.h   ipostscriptwriter.h   iprobefilter.h   iprogressbar.h   iqtwindow.h   irenderwindow.h   irenderwindowinteractor.h   iruler.h   iscaledlodactor.h   iscript.h  istreamline.h   isurface.h   isurfaceshifter.h   itensor.h   itensordataconverter.h   itext.h   itextactor.h   itextbitmap.h   itextvector.h   itrackball.h   iuniformmeshdata.h   iuniformmeshdataconverter.h   iuniformmeshdataextender.h   ivariablesview.h   ivector.h   iversion.h   ivisualobject.h   ivisualobjectobserver.h   ivolume.h   ivolumedataconverter.h   ivtk.h   ivtkcallback.h   ivtkwindow.h   ixsection.h 

SOURCES += idialogeventrecorder_body.cpp idialoghelp_body.cpp idialogimagecomposer_body.cpp idialogpaletteeditor_body.cpp idialogpickextension_body.cpp idialogscripter_body.cpp idialogvariablesexplorer_body.cpp iqt_body.cpp iqt_anim_body.cpp iqt_data_body.cpp iqt_menu_body.cpp iqt_part_body.cpp iqt_surf_body.cpp iqt_tens_body.cpp iqt_vect_body.cpp iqt_view_body.cpp iqt_volv_body.cpp iqt_wins_body.cpp iqt_xsec_body.cpp ivtk-iqt.cpp main.cpp bugfixes.cpp fftpack.cpp

HEADERS += icolor.h icontourfilter.h idatainfo.h idecimator.h ierror.h ifile.h ifamily.h ihelp.h ilabel.h imath.h iopengl.h ivisualobjectfamily.h ivisualobjectsource.h iqtdefs.h istring.h ivtksource.h iversion.h

######################################################################
# Automatically generated by qmake (1.02a) Fri Jun 28 10:18:53 2002
######################################################################

RC_FILE = ifrit.rc

UI_DIR = .ui
MOC_DIR = .moc
OBJECTS_DIR = .obj

!isEmpty(I) {
   NICK = 1
   IFRIT_VP1000 = 1
   SOLARIS = 1
}
#
#  Editions
#
!isEmpty(NICK) {
   DEFINES += "EDITION=1"
   HART = 1
   SOURCES += editionN.cpp
   message(Building Nick's Personal Edition...)
}

!isEmpty(CU) {
   DEFINES += "EDITION=2"
   SOLARIS = 1
   SOURCES += editionC.cpp
   message(Building CU Edition...)
}
#
#  Extensions
#
!isEmpty(HART_EXCLUSIVE) {
   HART = 1
   message(Exclusive HART Edition is no longet supported)
}

!isEmpty(HART) {
   DEFINES += "EXTENSION=1"
}

!isEmpty(HART) {

   message(Including HART support...)

   FORMS += hqt_view.ui hqt_surf.ui hqt_xsec.ui hqt_volv.ui hqt_part.ui hqt_vect.ui hqt_tens.ui hqt_mesh.ui hqt_vars.ui hdialoglevelchooser.ui hdialoglevelchooserextension.ui hdialogcosmologywarning.ui 

   SOURCES += habstracttreetraveller.cpp hanimatorscript.cpp hdatareader.cpp hdialoghelp.cpp hdialogvariablesexplorer.cpp henvironment.cpp hhedgehog.cpp hhistogrammaker.cpp hlimits.cpp hmarchingcubes.cpp hmergepoints.cpp hmesh.cpp hmeshdata.cpp hmeshdatacacheoptimizer.cpp hmeshextractor.cpp horthoplane.cpp hpartdata.cpp hparticles.cpp hqtextension.cpp hstreamline.cpp hsurface.cpp htensor.cpp htensorglyph.cpp hvector.cpp hvolume.cpp hvolumetexturemapper2D.cpp hvtk.cpp hxsection.cpp

   HEADERS += habstracttreetraveller.h   hanimatorscript.h   hdatareader.h   hdialoghelp.h   hdialogvariablesexplorer.h   henvironment.h   hhedgehog.h   hhistogrammaker.h   hlimits.h   hmarchingcubes.h   hmergepoints.h   hmesh.h   hmeshdata.h   hmeshdatacacheoptimizer.h   hmeshextractor.h   horthoplane.h   hpartdata.h   hparticles.h   hqtextension.h   hstreamline.h   hsurface.h   htensor.h   htensorglyph.h   hvector.h   hvolume.h   hvolumetexturemapper2D.h   hvtk.h   hxsection.h  

   HEADERS += hcosmology.h hdatainfo.h hid.h hmaxlevel.h hobjects.h hqtdefs.h hvisualobjectobservertypes.h hhelp.h

   IMAGES += images/hart.png images/hartfileopen.png images/hartmesh.png images/hartvars.png images/hartlarge.png images/hartdarkm.png images/hartstars.png images/hartcosm.png 

}


isEmpty(IFRIT_VP1000) {
   !isEmpty(VOLUMEPRO) {
      message(Using VTK native support for VolumePro1000...)
   }
}

!isEmpty(IFRIT_NO_SYNTAX_HIGHLIGHTING) {
   DEFINES += I_NO_SYNTAX_HIGHLITE
} else {
   SOURCES += isyntaxhighlighter.cpp
   HEADERS += isyntaxhighlighter.h
}

!isEmpty(IFRIT_VP1000) {
   VOLUMEPRO = 1
   message(Including IFRIT own support for VolumePro1000...)
   SOURCES += ivolumepromapper.cpp ivolumeprovp1000mapper.cpp iopenglvolumeprovp1000mapper.cpp
   HEADERS += ivolumepromapper.h   ivolumeprovp1000mapper.h   iopenglvolumeprovp1000mapper.h
   DEFINES += I_VTK_HAVE_VP1000
   INCLUDEPATH += $(VLI3DIR)
}

#
#  Extra configuration options
#

exists($(VTKDIR)/include): INCLUDEPATH += $(VTKDIR)/include
unix {
   exists($(VTKDIR)/lib): LIBS += -L$(VTKDIR)/lib
}


unix {
   exists(/usr/X11R6/include): INCLUDEPATH += /usr/X11R6/include
   exists(/usr/X11R6/lib): LIBS += -L/usr/X11R6/lib
}

!isEmpty(EXTRA_PATH) {
   INCLUDEPATH += $$join(EXTRA_PATH,"/include","","/include") 
   LIBS += $$join(EXTRA_PATH,"/lib","-L","/lib") 
}


!isEmpty(EXTRA_DEFINES) {
   DEFINES += $$EXTRA_DEFINES
} 

#
# Libraries have to be in the correct order for proper linking when they are
# static
#
unix:LIBS += -L$(VTKDIR)/bin

!isEmpty(VOLUMEPRO) {
   unix: LIBS += -lvli3 -lposix4
}

win32 {
   exists($(VTKDIR)/bin/Release/vtkDICOMParser.lib): LIBS += $(VTKDIR)/bin/Release/vtkDICOMParser.lib 
   exists($(VTKDIR)/bin/Release/vtkPatented.lib): LIBS += $(VTKDIR)/bin/Release/vtkPatented.lib 
}   
unix {
   exists($(VTKDIR)/bin/libvtkPatented.*): LIBS += -lvtkPatented
   exists($(VTKDIR)/bin/libvtkDICOMParser.*): LIBS += -lvtkDICOMParser
}

unix{
   !isEmpty(SOLARIS) {
      LIBS += -R$(VTKDIR)/bin -R$(QTDIR)/lib
   }
   !isEmpty(MACOSX) {
      LIBS += -framework Carbon -framework OpenGL -framework AGL -lX11 -bind_at_load
   }
   isEmpty(MACOSX) {
      LIBS += -lGL
   }
}


FORMS	+= idialogabout.ui idialogpopup.ui idialogcalculator.ui idialogscripter.ui idialogmessage.ui idialogpaletteeditor.ui iqt.ui iqt_view.ui iqt_surf.ui iqt_xsec.ui iqt_volv.ui iqt_part.ui iqt_vect.ui iqt_tens.ui iqt_data.ui idialogerrorlist.ui idialoghelp.ui iqt_wins.ui idialogpick.ui idialogpickextension.ui idialogeventrecorder.ui idialogprogress.ui idialogscriptvariablesview.ui idialogparallelcontroller.ui iqtextension.ui idialogloadfile.ui idialogvariablesexplorer.ui idialogimagecomposer.ui
IMAGES	+= images/genie1.png images/b14_13.png images/b14_10a.png images/genie2.png images/genie1_frame_000.png images/genie1_frame_001.png images/genie1_frame_002.png images/genie1_frame_003.png images/genie1_frame_004.png images/genie1_frame_005.png images/genie1_frame_006.png images/genie1_frame_007.png images/genie1_frame_008.png images/genie1_frame_009.png images/genie1_frame_010.png images/genie1_frame_011.png images/genie1_frame_012.png images/genie1_frame_013.png images/genie1_frame_014.png images/view.png images/flyby.png images/fileopenmesh.png images/fileopenpart.png images/fileopenset.png images/fileopentens.png images/fileopenvect.png images/part.png images/vect.png images/xsec.png images/tens.png images/data.png images/dock.png images/surf.png images/volv.png images/compile.png images/run.png images/error.png images/fontsize.png images/forward.png images/home.png images/backward.png images/close.png images/editcopy.png images/editcut.png images/editpaste.png images/filenew.png images/fileopen.png images/filesave.png images/redo.png images/searchfind.png images/undo.png images/vtklogo.png images/qtlogo.png images/debug.png images/wins.png images/winclone.png images/winindiv.png images/scted.png images/picks.png images/paled.png images/genie1qt.png images/genie1vtk.png images/mesh.png images/keyboard.png images/keyboardoff.png images/recorder.png images/er_play.png images/er_playon.png images/er_rec.png images/er_recon.png images/er_stop.png images/er_rew.png images/moveup.png images/movedown.png images/movetop.png images/debug_breakpoint.png images/debug_work.png images/debug_done.png images/debug_bpwork.png images/debug_bpdone.png images/parallel.png images/varexp.png images/imcomp.png
TEMPLATE	=app
win32:DEFINES	+= _WIN32
INCLUDEPATH	+= $(VTKDIR) $(VTKDIR)/Common $(VTKDIR)/Filtering $(VTKDIR)/Graphics $(VTKDIR)/Hybrid $(VTKDIR)/Imaging $(VTKDIR)/IO $(VTKDIR)/Parallel $(VTKDIR)/Patented $(VTKDIR)/Rendering .
win32:LIBS	+= $(VTKDIR)/bin/Release/vtkCommon.lib $(VTKDIR)/bin/Release/vtkFiltering.lib $(VTKDIR)/bin/Release/vtkGraphics.lib $(VTKDIR)/bin/Release/vtkImaging.lib $(VTKDIR)/bin/Release/vtkRendering.lib $(VTKDIR)/bin/Release/vtkIO.lib $(VTKDIR)/bin/Release/vtkHybrid.lib $(VTKDIR)/bin/Release/vtkParallel.lib $(VTKDIR)/bin/Release/vtkjpeg.lib $(VTKDIR)/bin/Release/vtkzlib.lib opengl32.lib glu32.lib glaux.lib
unix:LIBS	+= -lpthread -ldl -lm -lvtkHybrid -lvtkParallel -lvtkRendering -lvtkGraphics -lvtkImaging -lvtkIO -lvtkFiltering -lvtkCommon -lvtkjpeg -lvtkzlib -lXt
DBFILE	= ifrit.db
LANGUAGE	= C++

isEmpty(VTK_NO_PNG) {
win32 {
   exists($(VTKDIR)/bin/Release/vtkpng.lib): LIBS += $(VTKDIR)/bin/Release/vtkpng.lib 
}   
unix {
   exists($(VTKDIR)/bin/libvtkpng.*): LIBS += -lvtkpng
}
}

win32 {
   exists($(VTKDIR)/bin/Release/vtktiff.lib): LIBS += $(VTKDIR)/bin/Release/vtktiff.lib 
   exists($(VTKDIR)/bin/Release/vtkexpat.lib): LIBS += $(VTKDIR)/bin/Release/vtkexpat.lib 
   exists($(VTKDIR)/bin/Release/vtkfreetype.lib): LIBS += $(VTKDIR)/bin/Release/vtkfreetype.lib 
   exists($(VTKDIR)/bin/Release/vtkftgl.lib): LIBS += $(VTKDIR)/bin/Release/vtkftgl.lib
}   
unix {
   exists($(VTKDIR)/bin/libvtktiff.*): LIBS += -lvtktiff
   exists($(VTKDIR)/bin/libvtkexpat.*): LIBS += -lvtkexpat
   exists($(VTKDIR)/bin/libvtkftgl.*): LIBS += -lvtkftgl
   exists($(VTKDIR)/bin/libvtkfreetype.*): LIBS += -lvtkfreetype
}

