/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

#include <string.h>
#include <qmessagebox.h>

#include "ifunctionparser.h"

void reportNullPointer(int);


//
//  Constructor, destructor
//
void iDialogCalculator::init()
{

    parentLineEdit = 0;
    parser = iFunctionParser::New();
	if(parser == 0) reportNullPointer(9101);

    parser->SetScalarVariableValue("Var1",1.234);
    parser->SetScalarVariableValue("Var2",1.234);
    parser->SetScalarVariableValue("Var3",1.234);
    parser->SetVectorVariableValue("Vector",0.0,0.0,0.0);
    
}

void iDialogCalculator::destroy()
{

    parser->Delete();
    
}
//
//  Operating functions
//
void iDialogCalculator::closeEvent( QCloseEvent *e )
{

	if(!buf.isEmpty()){
		if(parser->checkSyntax(buf.latin1()) == 0){
			if(parser->IsScalarResult() != 0) 
				e->accept();
			else
				QMessageBox::critical(this,"IFRIT Array Calculator",QString("Error: result is a vector"));
		}
	} else e->accept();
        
}


void iDialogCalculator::setParentLineEdit( QLineEdit *p, QString *s )
{

    parentLineEdit = p;
    parentList = s;
    buf = p->text();
    list = *s;
    LineEdit->setText(buf);
    
}


void iDialogCalculator::insertEntry( char *s )
{
    
    buf += s;
    list += (char)strlen(s);
    LineEdit->setText(buf);
    if(parentLineEdit) parentLineEdit->setText(buf);
    if(parentList) *parentList = list;
    
}


void iDialogCalculator::deleteEntry()
{

    if(list.length() > 0) {
	buf.truncate(buf.length()-list.constref(list.length()-1).latin1());
	list.truncate(list.length()-1);
	LineEdit->setText(buf);
	if(parentLineEdit) parentLineEdit->setText(buf);
	if(parentList) *parentList = list;
    }
    
}
//
//  Buttons
//
void iDialogCalculator::buttonAbs()
{

    this->insertEntry("abs(");
    
}

void iDialogCalculator::buttonAcos()
{

    this->insertEntry("acos(");
    
}

void iDialogCalculator::buttonAsin()
{

    this->insertEntry("asin(");
    
}

void iDialogCalculator::buttonAtan()
{

    this->insertEntry("atan(");
    
}

void iDialogCalculator::buttonCos()
{

    this->insertEntry("cos(");
    
}

void iDialogCalculator::buttonCosh()
{

    this->insertEntry("cosh(");
    
}

void iDialogCalculator::buttonD0()
{

    this->insertEntry("0");
    
}

void iDialogCalculator::buttonD1()
{

    this->insertEntry("1");
    
}

void iDialogCalculator::buttonD2()
{

    this->insertEntry("2");
    
}

void iDialogCalculator::buttonD3()
{

    this->insertEntry("3");
    
}

void iDialogCalculator::buttonD4()
{

    this->insertEntry("4");
    
}

void iDialogCalculator::buttonD5()
{

    this->insertEntry("5");
    
}

void iDialogCalculator::buttonD6()
{

    this->insertEntry("6");
    
}

void iDialogCalculator::buttonD7()
{

    this->insertEntry("7");
    
}

void iDialogCalculator::buttonD8()
{

    this->insertEntry("8");
    
}

void iDialogCalculator::buttonD9()
{

    this->insertEntry("9");
    
}

void iDialogCalculator::buttonDe()
{

    this->insertEntry("E");
    
}

void iDialogCalculator::buttonDel()
{

    this->deleteEntry();
    
}

void iDialogCalculator::buttonDiv()
{

    this->insertEntry("/");
    
}

void iDialogCalculator::buttonDp()
{

    this->insertEntry(".");
    
}

void iDialogCalculator::buttonExp()
{

    this->insertEntry("exp(");
    
}

void iDialogCalculator::buttonLog()
{

    this->insertEntry("log(");
    
}

void iDialogCalculator::buttonMag()
{

    this->insertEntry("mag(");
    
}

void iDialogCalculator::buttonMin()
{

    this->insertEntry("-");
    
}

void iDialogCalculator::buttonMul()
{

    this->insertEntry("*");
    
}

void iDialogCalculator::buttonPar1()
{

    this->insertEntry("(");
    
}

void iDialogCalculator::buttonPar2()
{

    this->insertEntry(")");
    
}

void iDialogCalculator::buttonPlu()
{

    this->insertEntry("+");
    
}

void iDialogCalculator::buttonPow()
{

    this->insertEntry("^");
    
}

void iDialogCalculator::buttonS1()
{

    this->insertEntry("Var1");
    
}

void iDialogCalculator::buttonS2()
{

    this->insertEntry("Var2");
    
}

void iDialogCalculator::buttonS3()
{

    this->insertEntry("Var3");
    
}

void iDialogCalculator::buttonSgn()
{

    this->insertEntry("-");
    
}

void iDialogCalculator::buttonSin()
{

    this->insertEntry("sin(");
    
}

void iDialogCalculator::buttonSinh()
{

    this->insertEntry("sinh(");
    
}

void iDialogCalculator::buttonSqr()
{

    this->insertEntry("sqrt(");
    
}

void iDialogCalculator::buttonTan()
{

    this->insertEntry("tan(");
    
}

void iDialogCalculator::buttonTanh()
{

    this->insertEntry("tanh(");
    
}

void iDialogCalculator::buttonVF()
{

    this->insertEntry("Vector");
    
}





