/* 
 * Copyright (c) 2007 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */
/**
 * @test
 * @bug 4257318
 * @author John O'Conner
 * @build Bug4257318Res Bug4257318Res_en
 * @run main Bug4257318
 */

import java.util.ResourceBundle;


public class Bug4257318 {
  ResourceBundle res;
  boolean passed;

  public Bug4257318() {
    passed = false;
    res = ResourceBundle.getBundle("Bug4257318Res", new java.util.Locale("","",""));
  }

  boolean run() {
    String str = res.getString("Hello");
    passed = str.equals("Hello from the root bundle!");
    System.out.println("Root bundle string: " + str);
    return passed;
  }

  public static void main(String[] args) throws Exception {
    boolean passed;
    Bug4257318 test = new Bug4257318();
    passed = test.run();
    if (!passed) {
      throw new Exception("Bug4257318 Test: FAILED");
    }
    
  }
}    



