/* 
 * Copyright 2002 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/* @test
 * @bug 4626311
 * @summary Protocol "rmi:" is used in contrary to spec.  The Naming.list
 * method should not append an "rmi:" scheme prefix to the URLs in the
 * array of Strings it returns.
 * @author Ann Wollrath
 *
 * @library ../testlibrary
 * @build TestLibrary
 * @build RmiIsNoScheme
 * @run main/othervm RmiIsNoScheme
 */

import java.io.*;
import java.rmi.*;
import java.rmi.registry.*;

public class RmiIsNoScheme implements Remote, Serializable {

    private static final int REGISTRY_PORT = 2002;

    private RmiIsNoScheme() {}

    public static void main(String[] args) {

	System.err.println("\nRegression test for bug 4626311\n");

	try {
	    LocateRegistry.createRegistry(REGISTRY_PORT);
	    Naming.rebind("//:" + REGISTRY_PORT + "/RmiIsNoScheme",
			  new RmiIsNoScheme());
	    String name = Naming.list("//:" + REGISTRY_PORT)[0];
	    System.err.println("name = " + name);
	    if (name.startsWith("rmi:", 0) == false) {
		System.err.println("TEST PASSED: rmi scheme not present");
	    } else {
		throw new RuntimeException("TEST FAILED: rmi scheme present!");
	    }
	} catch (Exception e) {
	    TestLibrary.bomb(e);
	}
    }
}
