/*
 * Copyright 2005 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/**
 * @test
 * @bug 6270015
 * @summary  Light weight HTTP server
 */

import java.net.*;
import java.util.*;
import java.util.concurrent.*;
import java.io.*;
import com.sun.net.httpserver.*;

public class Test11 {
    static class Handler implements HttpHandler {
	public void handle(HttpExchange t) throws IOException {
	    read (t.getRequestBody());
	    String response = "response";
	    t.sendResponseHeaders (200, response.length());
	    OutputStream os = t.getResponseBody();
	    os.write (response.getBytes ("ISO8859_1"));
	    t.close();
	}

  	void read (InputStream is ) throws IOException {
	    byte[] b = new byte [8096];
	    while (is.read (b) != -1) {}
	}
    }

    public static void main (String[] args) throws Exception {
	System.out.print ("Test 11: ");
	HttpServer server = HttpServer.create (new InetSocketAddress(0), 0);
	HttpContext ctx = server.createContext (
	    "/foo/bar/", new Handler ()
	);
	ExecutorService s =  Executors.newCachedThreadPool();
	server.setExecutor (s);
	server.start ();
	URL url = new URL ("http://localhost:" + server.getAddress().getPort()+
		"/Foo/bar/test.html");
	HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
	int r = urlc.getResponseCode();
	System.out.println ("OK");
	s.shutdown();
	server.stop(5);
	if (r == 200) {
	    throw new RuntimeException ("wrong response received");
	}
    }
}
