/*
 * Copyright 2004-2007 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */


package sun.security.krb5.internal.crypto;

import sun.security.krb5.internal.crypto.dk.Des3DkCrypto;
import sun.security.krb5.KrbCryptoException;
import java.security.GeneralSecurityException;

/**
 * Class with static methods for doing Triple DES operations.
 */
public class Des3 {
    private static final Des3DkCrypto CRYPTO = new Des3DkCrypto();

    private Des3() {
    }

    public static byte[] stringToKey(char[] chars) 
	throws GeneralSecurityException {
	return CRYPTO.stringToKey(chars);
    }

    public static byte[] parityFix(byte[] value) 
	throws GeneralSecurityException {
	return CRYPTO.parityFix(value);
    }

    // in bytes
    public static int getChecksumLength() {
	return CRYPTO.getChecksumLength();
    }

    public static byte[] calculateChecksum(byte[] baseKey, int usage, 
	byte[] input, int start, int len) throws GeneralSecurityException {
	    return CRYPTO.calculateChecksum(baseKey, usage, input, start, len);
    }

    public static byte[] encrypt(byte[] baseKey, int usage, 
	byte[] ivec, byte[] plaintext, int start, int len) 
	throws GeneralSecurityException, KrbCryptoException {
	    return CRYPTO.encrypt(baseKey, usage, ivec, null /* new_ivec */,
		plaintext, start, len);
    }

    /* Encrypt plaintext; do not add confounder, padding, or checksum */
    public static byte[] encryptRaw(byte[] baseKey, int usage, 
	byte[] ivec, byte[] plaintext, int start, int len) 
	throws GeneralSecurityException, KrbCryptoException {
        return CRYPTO.encryptRaw(baseKey, usage, ivec, plaintext, start, len);
    }
    
    public static byte[] decrypt(byte[] baseKey, int usage, byte[] ivec,
	byte[] ciphertext, int start, int len) 
        throws GeneralSecurityException {
        return CRYPTO.decrypt(baseKey, usage, ivec, ciphertext, start, len);
    }

    /** 
     * Decrypt ciphertext; do not remove confounder, padding, 
     * or check checksum 
     */
    public static byte[] decryptRaw(byte[] baseKey, int usage, byte[] ivec,
	byte[] ciphertext, int start, int len) 
	throws GeneralSecurityException {
        return CRYPTO.decryptRaw(baseKey, usage, ivec, ciphertext, start, len);
    }
};
