'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbResizeKeyActions __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbResizeKeyActions \- Change the number of actions bound to a key
.SH SYNOPSIS
.HP
.B XkbAction * XkbResizeKeyActions
.BI "(\^XkbDescRec *" "xkb" "\^,"
.BI "int " "key" "\^,"
.BI "int " "needed" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description to change
.TP
.I \- key
keycode of key to change
.TP
.I \- needed
new number of actions required
.SH DESCRIPTION
.LP
The 
.I xkb 
parameter points to the keyboard description containing the 
.I key 
whose number of actions is to be changed. The 
.I key 
parameter is the keycode of the key to change, and needed specifies the new 
number of actions required for the key.

.I XkbResizeKeyActions 
reserves the space needed for the actions and returns a pointer to the beginning 
of the new array that holds the actions. It can change the 
.I acts, num_acts, 
and 
.I size_acts 
fields of 
.I xkb->server 
if it is necessary to reallocate the 
.I acts 
array.

If 
.I needed 
is greater than the current number of keysyms for the key, 
.I XkbResizeKeyActions 
initializes all new actions in the array to NoAction.

Because the number of actions needed by a key is normally computed as width * 
number of groups, and 
.I XkbResizeKeyActions 
does not modify either the width or number of groups for the key, a discrepancy 
exists on return from 
.I XkbResizeKeyActions 
between the space allocated for the actions and the number required. The unused 
entries in the list of actions returned by 
.I XkbResizeKeyActions 
are not preserved across future calls to any of the map editing functions, so 
you must update the key actions (which updates the width and number of groups 
for the key) before calling another allocator function. A call to
.I XkbChangeTypesOfKey 
updates these.

If any allocation errors occur while resizing the number of actions bound to the 
key, 
.I XkbResizeKeyActions 
returns NULL.
.SH "SEE ALSO"
.BR XkbChangeTypesOfKey (__libmansuffix__),
.BR XkbResizeKeySyms (__libmansuffix__)
.SH NOTES
.LP
A change to the number of actions bound to a key should be accompanied by a 
change in the number of symbols bound to a key. Refer to 
.I XkbResizeKeySyms 
for more information on changing the number of symbols bound to a key.
