'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbNoteNameChanges __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbNoteNameChanges \- Note the changed names in a changes structure
.SH SYNOPSIS
.HP
.B void XkbNoteNameChanges
.BI "(\^XkbNameChangesPtr " "old" "\^,"
.BI "XkbNamesNotifyEvent *" "new" "\^,"
.BI "unsigned int " "wanted" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- old
XkbNameChanges structure to be updated
.TP
.I \- new
event from which changes are to be copied
.TP
.I \- wanted
types of names for which changes are to be noted
.SH DESCRIPTION
.LP
When your application receives a XkbNamesNotify event, you can note the changed 
names in a changes structure using 
.I XkbNoteNameChanges.

The 
.I wanted 
parameter is the bitwise inclusive OR of the valid names mask bits shown in 
Table 1. 
.I XkbNoteNameChanges 
copies any changes that are reported in 
.I new 
and specified in 
.I wanted 
into the changes record specified by 
.I old.

.TS
c s s s
l l l l.
Table 1 Symbolic Names Masks
_
Mask Bit	Value	Keyboard	Field
		Component
_
XkbKeycodesNameMask	(1<<0)	Xkb->names	keycodes
XkbGeometryNameMask	(1<<1)	Xkb->names	geometry
XkbSymbolsNameMask	(1<<2)	Xkb->names	symbols
XkbPhysSymbolsNameMask	(1<<3)	Xkb->names	phys_symbols
XkbTypesNameMask	(1<<4)	Xkb->names	type
XkbCompatNameMask	(1<<5)	Xkb->names	compat
XkbKeyTypeNamesMask	(1<<6)	Xkb->map	type[*].name
XkbKTLevelNamesMask	(1<<7)	Xkb->map	type[*].lvl_names[*]
XkbIndicatorNamesMask	(1<<8)	Xkb->names	indicators[*]
XkbKeyNamesMask	(1<<9)	Xkb->names	keys[*], num_keys
XkbKeyAliasesMask	(1<<10)	Xkb->names	key_aliases[*], num_key_aliases
XkbVirtualModNamesMask	(1<<11)	Xkb->names	vmods[*]
XkbGroupNamesMask	(1<<12)	Xkb->names	groups[*]
XkbRGNamesMask	(1<<13)	Xkb->names	radio_groups[*], num_rg
XkbComponentNamesMask	(0x3f)	Xkb->names	keycodes,
			geometry,
			symbols,
			physical symbols,
			types, and
			compatibility map
XkbAllNamesMask	(0x3fff)	Xkb->names	all name components
.TE

