.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbLibraryVersion __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbLibraryVersion \-  Determines the compatibility of a library at runtime.
.SH SYNOPSIS
.HP
.B Bool XkbLibraryVersion
.BI "(\^int *" "lib_major_in_out" "\^,"
.BI "int *" "lib_minor_in_out" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I lib_major_in_out
Specifies and returns the major Xkb library version.
.TP
.I lib_minor_in_out
Specifies and returns the minor Xkb library version.
.SH DESCRIPTION
.LP
If an application is dynamically linked, both the X server and the client-side X 
library must contain the Xkb extension in order for the client to use the Xkb 
extension capabilities. Therefore a dynamically linked application must check 
both the library and the server for compatibility before using Xkb function 
calls. A properly written program must check for compatibility between the 
version of the Xkb library that is dynamically loaded and the one used when the 
application was built. It must then check the server version for compatibility 
with the version of Xkb in the library.

If your application is statically linked, you must still check for server 
compatibility and may check library compatibility. (It is possible to compile 
against one set of header files and link against a different, incompatible, 
version of the library, although this should not normally occur.)

Pass the symbolic value XkbMajorVersion in 
.I lib_major_in_out 
and XkbMinorVersion in 
.I lib_minor_in_out. 
These arguments represent the version of the library used 
at compile time. The 
.I XkbLibraryVersion 
function backfills the major and minor version numbers of the library used at 
run time in 
.I lib_major_in_out and 
.I lib_minor_in_out. 
If the versions of the compile time and run time libraries are 
compatible, 
.I XkbLibraryVersion 
returns True, otherwise, it returns False.

In addition, in order to use the Xkb extension, you must ensure that the 
extension is present in the server and that the server supports the version of 
the extension expected by the client. Use 
.I XkbQueryExtension 
to do this, as described in the next section.
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbLibraryVersion 
returns True if the versions of the compile time and run time libraries are 
compatible.
.TP 15
False
The 
.I XkbLibraryVersion 
returns False if the versions of the compile time and run time libraries are not 
compatible.
.SH "SEE ALSO"
.BR XkbMajorVersion (__libmansuffix__),
.BR XkbMinorVersion (__libmansuffix__),
.BR XkbQueryExtension (__libmansuffix__)
