'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbFreeDeviceInfo __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbFreeDeviceInfo \- Free an XkbDeviceInfoRec structure
.SH SYNOPSIS
.HP
.B void XkbFreeDeviceInfo
.BI "(\^XkbDeviceInfoPtr " "device_info" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "Bool " "free_all" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- device_info
pointer to XkbDeviceInfoRec in which to free items
.TP
.I \- which
mask of components of device_info to free
.TP
.I \- free_all
True => free everything, including device_info
.SH DESCRIPTION
.LP
If 
.I free_all 
is True, the 
.I XkbFreeDeviceInfo 
frees all components of 
.I device_info 
and the XkbDeviceInfoRec structure pointed to by 
.I device_info 
itself. If 
.I free_all 
is False, the value of 
.I which 
determines which subcomponents are freed. 
.I which 
is an inclusive OR of one or more of the values from Table 1. If 
.I which 
contains XkbXI_ButtonActionsMask, all button actions associated with 
.I device_info 
are freed, 
.I device_info->btn_acts 
is set to NULL, and 
.I device_info->num_btns 
is set to zero. If 
.I which 
contains all bits in XkbXI_IndicatorsMask, all XkbDeviceLedInfoRec structures associated with 
.I device_info 
are freed, 
.I device_info->leds 
is set to NULL, and 
.I device_info->sz_leds 
and 
.I device_info->num_leds 
are set to zero. If 
.I which 
contains XkbXI_IndicatorMapsMask, all indicator maps associated with 
.I device_info 
are cleared, but the number of LEDs and the leds structures themselves is preserved. If 
.I which 
contains XkbXI_IndicatorNamesMask, all indicator names associated with
.I device_info 
are cleared, but the number of LEDs and the leds structures themselves is preserved. If 
.I which 
contains XkbXI_IndicatorStateMask, the indicator state associated with the
.I device_info 
leds are set to zeros but the number of LEDs and the leds structures themselves is preserved.
.bp
.nf
                         Table 1 XkbDeviceInfoRec Mask Bits                        
____________________________________________________________________________________
Name                         XkbDeviceInfoRec Value     Capability If Set
                             Fields Effected            
____________________________________________________________________________________
XkbXI_KeyboardsMask                           (1L <<0) Clients can use all
                                                       Xkb requests and events
                                                       with KeyClass devices 
                                                       supported by the input
                                                       device extension.

XkbXI_ButtonActionsMask       num_btns        (1L <<1) Clients can assign key 
                              btn_acts                 actions to buttons 
                                                       non-KeyClass input
                                                       extension devices.
                           
XkbXI_IndicatorNamesMask      leds->names     (1L <<2) Clients can assign
                                                       names to indicators on
                                                       non-KeyClass input
                                                       extension devices.
                                                             
XkbXI_IndicatorMapsMask       leds->maps      (1L <<3) Clients can assign
                                                       indicator maps to
                                                       indicators on 
                                                       non-KeyClass input
                                                       extension devices.

XkbXI_IndicatorStateMask      leds->state     (1L <<4) Clients can request 
                                                       the status of indicators
                                                       on non-KeyClass input
                                                       extension devices.

XkbXI_IndicatorsMask          sz_leds         (0x1c)   XkbXI_IndicatorNamesMask |
                              num_leds                 XkbXI_IndicatorMapsMask |
                              leds->*                  XkbXI_IndicatorStateMask

XkbXI_UnsupportedFeaturesMask unsupported     (1L <<15)

XkbXI_AllDeviceFeaturesMask   Those selected  (0x1e)   XkbXI_IndicatorsMask |
                              by Value Column          XkbSI_ButtonActionsMask
                              masks 

XkbXI_AllFeaturesMask         Those selected  (0x1f)   XkbSI_AllDeviceFeaturesMask |
                              by Value Column          XkbSI_KeyboardsMask
                              masks

XkbXI_AllDetailsMask          Those selected  (0x801f) XkbXI_AllFeaturesMask |
                              by Value column          XkbXI_UnsupportedFeaturesMask
                              masks
.fi
.SH STRUCTURES
.LP
Information about X Input Extension devices is transferred between a client program and the Xkb 
extension in an XkbDeviceInfoRec structure:
.nf

typedef struct {
    char *               name;          /\(** name for device */
    Atom                 type;          /\(** name for class of devices */
    unsigned short       device_spec;   /\(** device of interest */
    Bool                 has_own_state; /\(** True=>this device has its own state */
    unsigned short       supported;     /\(** bits indicating supported capabilities */
    unsigned short       unsupported;   /\(** bits indicating unsupported capabilities */
    unsigned short       num_btns;      /\(** number of entries in btn_acts */
    XkbAction *          btn_acts;      /\(** button actions */
    unsigned short       sz_leds;       /\(** total number of entries in LEDs vector */
    unsigned short       num_leds;      /\(** number of valid entries in LEDs vector */
    unsigned short       dflt_kbd_fb;   /\(** input extension ID of default (core kbd) indicator */
    unsigned short       dflt_led_fb;   /\(** input extension ID of default indicator feedback */
    XkbDeviceLedInfoPtr  leds;          /\(** LED descriptions */
} XkbDeviceInfoRec, *XkbDeviceInfoPtr;
    
typedef struct {
    unsigned short      led_class;        /\(** class for this LED device*/
    unsigned short      led_id;           /\(** ID for this LED device */
    unsigned int        phys_indicators;  /\(** bits for which LEDs physically present */
    unsigned int        maps_present;     /\(** bits for which LEDs have maps in maps */
    unsigned int        names_present;    /\(** bits for which LEDs are in names */
    unsigned int        state;            /\(** 1 bit => corresponding LED is on */
    Atom                names[XkbNumIndicators];   /\(** names for LEDs */
    XkbIndicatorMapRec  maps;             /\(** indicator maps for each LED */
} XkbDeviceLedInfoRec, *XkbDeviceLedInfoPtr;

.fi    
