/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGRect.h"

#include <wtf/GetPtr.h>


using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGRectTableEntries[] =
{
    { "y", JSSVGRect::YAttrNum, DontDelete, 0, 0 },
    { "x", JSSVGRect::XAttrNum, DontDelete, 0, &JSSVGRectTableEntries[4] },
    { 0, 0, 0, 0, 0 },
    { "width", JSSVGRect::WidthAttrNum, DontDelete, 0, 0 },
    { "height", JSSVGRect::HeightAttrNum, DontDelete, 0, 0 }
};

static const HashTable JSSVGRectTable = 
{
    2, 5, JSSVGRectTableEntries, 4
};

/* Hash table for prototype */

static const HashEntry JSSVGRectPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGRectPrototypeTable = 
{
    2, 1, JSSVGRectPrototypeTableEntries, 1
};

const ClassInfo JSSVGRectPrototype::info = { "SVGRectPrototype", 0, &JSSVGRectPrototypeTable, 0 };

JSObject* JSSVGRectPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGRectPrototype>(exec, "[[JSSVGRect.prototype]]");
}

const ClassInfo JSSVGRect::info = { "SVGRect", 0, &JSSVGRectTable, 0 };

JSSVGRect::JSSVGRect(ExecState* exec, JSSVGPODTypeWrapper<FloatRect>* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGRectPrototype::self(exec));
}

JSSVGRect::~JSSVGRect()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGRect::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRect, KJS::DOMObject>(exec, &JSSVGRectTable, this, propertyName, slot);
}

JSValue* JSSVGRect::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case XAttrNum: {
        FloatRect& imp(*impl());

        return jsNumber(imp.x());
    }
    case YAttrNum: {
        FloatRect& imp(*impl());

        return jsNumber(imp.y());
    }
    case WidthAttrNum: {
        FloatRect& imp(*impl());

        return jsNumber(imp.width());
    }
    case HeightAttrNum: {
        FloatRect& imp(*impl());

        return jsNumber(imp.height());
    }
    }
    return 0;
}

void JSSVGRect::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGRect, KJS::DOMObject>(exec, propertyName, value, attr, &JSSVGRectTable, this);
}

void JSSVGRect::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XAttrNum: {
        FloatRect& imp(*impl());

        imp.setX(value->toFloat(exec));
        m_impl->commitChange(exec);
        break;
    }
    case YAttrNum: {
        FloatRect& imp(*impl());

        imp.setY(value->toFloat(exec));
        m_impl->commitChange(exec);
        break;
    }
    case WidthAttrNum: {
        FloatRect& imp(*impl());

        imp.setWidth(value->toFloat(exec));
        m_impl->commitChange(exec);
        break;
    }
    case HeightAttrNum: {
        FloatRect& imp(*impl());

        imp.setHeight(value->toFloat(exec));
        m_impl->commitChange(exec);
        break;
    }
    }
}

KJS::JSValue* toJS(KJS::ExecState* exec, JSSVGPODTypeWrapper<FloatRect>* obj)
{
    return KJS::cacheDOMObject<JSSVGPODTypeWrapper<FloatRect>, JSSVGRect>(exec, obj);
}
FloatRect toSVGRect(KJS::JSValue* val)
{
    return val->isObject(&JSSVGRect::info) ? (FloatRect) *static_cast<JSSVGRect*>(val)->impl() : FloatRect();
}

}

#endif // ENABLE(SVG)
