i3-msg(1)
=========
Michael Stapelberg <michael@i3wm.org>
v4.2, August 2012

== NAME

i3-msg - send messages to i3 window manager

== SYNOPSIS

i3-msg  [-q] [-v] [-h] [-s socket] [-t type] [message]

== OPTIONS

*-q, --quiet*::
Only send ipc message and suppress the output of the response.

*-v, --version*::
Display version number and exit.

*-h, --help*::
Display a short help-message and exit.

*-s, --socket* 'sock_path'::
i3-msg will use the environment variable I3SOCK or the socket path
given here. If both fail, it will try to get the socket information
from the root window and then try /tmp/i3-ipc.sock before exiting
with an error.

*-t* 'type'::
Send ipc message, see below.

*message*::
Send ipc message, see below.

== IPC MESSAGE TYPES

command::
The payload of the message is a command for i3 (like the commands you can bind
to keys in the configuration file) and will be executed directly after
receiving it.

get_workspaces::
Gets the current workspaces. The reply will be a JSON-encoded list of
workspaces.

get_outputs::
Gets the current outputs. The reply will be a JSON-encoded list of outputs (see
the reply section of docs/ipc, e.g. at
http://i3wm.org/docs/ipc.html#_receiving_replies_from_i3).

get_tree::
Gets the layout tree. i3 uses a tree as data structure which includes every
container. The reply will be the JSON-encoded tree.

get_marks::
Gets a list of marks (identifiers for containers to easily jump to them later).
The reply will be a JSON-encoded list of window marks.

get_bar_config::
Gets the configuration (as JSON map) of the workspace bar with the given ID. If
no ID is provided, an array with all configured bar IDs is returned instead.

get_version::
Gets the version of i3. The reply will be a JSON-encoded dictionary with the
major, minor, patch and human-readable version.

== DESCRIPTION

i3-msg is a sample implementation for a client using the unix socket IPC
interface to i3.

== EXAMPLES

------------------------------------------------
# Use 1-px border for current client
i3-msg "border 1pixel"

# You can leave out the quotes
i3-msg border normal

# Dump the layout tree
i3-msg -t get_tree
------------------------------------------------

== ENVIRONMENT

=== I3SOCK

If no ipc-socket is specified on the commandline, this variable is used
to determine the path, at which the unix domain socket is expected, on which
to connect to i3.

== SEE ALSO

i3(1)

== AUTHOR

Michael Stapelberg and contributors
